/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.decoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderContext;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderException;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoder;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoderUtil;
import com.hivemq.client.internal.mqtt.codec.decoder.mqtt5.Mqtt5MessageDecoderUtil;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertyImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.publish.pubrel.MqttPubRel;
import com.hivemq.client.internal.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.client.internal.shaded.javax.inject.Inject;
import com.hivemq.client.internal.shaded.javax.inject.Singleton;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.mqtt5.message.publish.pubrel.Mqtt5PubRelReasonCode;

@Singleton
public class Mqtt5PubRelDecoder
implements MqttMessageDecoder {
    private static final int FLAGS = 2;
    private static final int MIN_REMAINING_LENGTH = 2;

    @Inject
    Mqtt5PubRelDecoder() {
    }

    @Override
    @NotNull
    public MqttPubRel decode(int flags, @NotNull ByteBuf in, @NotNull MqttDecoderContext context) throws MqttDecoderException {
        MqttMessageDecoderUtil.checkFixedHeaderFlags(2, flags);
        if (in.readableBytes() < 2) {
            throw MqttMessageDecoderUtil.remainingLengthTooShort();
        }
        int packetIdentifier = in.readUnsignedShort();
        Mqtt5PubRelReasonCode reasonCode = MqttPubRel.DEFAULT_REASON_CODE;
        MqttUtf8StringImpl reasonString = null;
        ImmutableList.Builder<MqttUserPropertyImpl> userPropertiesBuilder = null;
        if (in.isReadable()) {
            reasonCode = Mqtt5PubRelReasonCode.fromCode(in.readUnsignedByte());
            if (reasonCode == null) {
                throw Mqtt5MessageDecoderUtil.wrongReasonCode();
            }
            if (in.isReadable()) {
                Mqtt5MessageDecoderUtil.checkPropertyLengthNoPayload(in);
                block4: while (in.isReadable()) {
                    int propertyIdentifier = Mqtt5MessageDecoderUtil.decodePropertyIdentifier(in);
                    switch (propertyIdentifier) {
                        case 31: {
                            reasonString = Mqtt5MessageDecoderUtil.decodeReasonStringIfRequested(reasonString, in, context);
                            continue block4;
                        }
                        case 38: {
                            userPropertiesBuilder = Mqtt5MessageDecoderUtil.decodeUserPropertyIfRequested(userPropertiesBuilder, in, context);
                            continue block4;
                        }
                    }
                    throw Mqtt5MessageDecoderUtil.wrongProperty(propertyIdentifier);
                }
            }
        }
        MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.build(userPropertiesBuilder);
        return new MqttPubRel(packetIdentifier, reasonCode, reasonString, userProperties);
    }
}

