/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.restful;

import ca.infodata.util1.group.Group;
import ca.infodata.util1.restful.GroupTypeAdapter;
import ca.infodata.util1.restful.MapRequestWriter;
import ca.infodata.util1.restful.RequestWriter;
import ca.infodata.util1.restful.Response;
import ca.infodata.util1.restful.ResponseReader;
import ca.infodata.util1.restful.WebBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractAccessorClient {
    private Client client;
    private final URL address;
    private final String contextRoot;

    public AbstractAccessorClient(URL address) {
        this(address, null);
    }

    public AbstractAccessorClient(URL address2, String contextRoot) {
        this.address = address2;
        this.contextRoot = contextRoot;
        DefaultClientConfig cc = new DefaultClientConfig();
        this.config((ClientConfig)cc);
        this.client = new Client((ClientHandler)new URLConnectionClientHandler(), (ClientConfig)cc);
    }

    protected void config(ClientConfig config) {
        GsonBuilder builder = new GsonBuilder();
        GroupTypeAdapter groupTypeAdapter = new GroupTypeAdapter();
        builder.registerTypeHierarchyAdapter(Group.class, (Object)groupTypeAdapter);
        Gson gson = builder.create();
        groupTypeAdapter.setGson(gson);
        config.getSingletons().add(new ResponseReader(gson));
        config.getSingletons().add(new MapRequestWriter(gson));
        config.getSingletons().add(new RequestWriter(gson));
    }

    protected void processResponse(Response<?> response) {
        if (response.errorIndicator.booleanValue()) {
            throw new RuntimeException(response.errorMessage);
        }
    }

    public void dispose() {
        this.client.destroy();
    }

    protected URI getSecureURI(String path) {
        try {
            if (this.contextRoot != null) {
                path = this.contextRoot + path;
            }
            return new URI(this.address.getProtocol(), null, this.address.getHost(), this.address.getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Map<String, Object> asMap(Object ... objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return Collections.emptyMap();
        }
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException("array must contains values by pair String, Object");
        }
        HashMap<String, Object> map = new HashMap<String, Object>(objects.length / 2);
        int i = 0;
        while (i < objects.length) {
            String key;
            if ((key = (String)objects[i++]) == null) {
                throw new IllegalArgumentException("key cant be null");
            }
            Object value = objects[i++];
            map.put(key, value);
        }
        return map;
    }

    protected WebBuilder buildWebBuilder(URI uri, String accept, String type) {
        WebBuilder wb = new WebBuilder(this.client.resource(uri), accept, type);
        return wb;
    }

    public Client getClient() {
        return this.client;
    }
}

