/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class EventLock {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private volatile boolean eventHasOccured = false;

    public boolean waitUntilEvent() {
        return this.waitUntilEvent(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEvent(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        this.lock.lock();
        try {
            if (this.eventHasOccured) {
                boolean bl = true;
                return bl;
            }
            if (timeout == 0L) {
                this.cond.awaitUninterruptibly();
                boolean bl = true;
                return bl;
            }
            boolean bl = this.cond.await(timeout, TimeUnit.MILLISECONDS);
            return bl;
        }
        catch (InterruptedException e1) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void eventOccured() {
        this.lock.lock();
        try {
            if (this.eventHasOccured) {
                return;
            }
            this.eventHasOccured = true;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean doesEventHasOccured() {
        return this.eventHasOccured;
    }

    public void reset() {
        Thread.yield();
        this.eventHasOccured = false;
    }
}

