/*
 * Decompiled with CFR 0.152.
 */
package parser;

import ca.infodata.readhl7.MessageHandler;
import ca.infodata.readhl7.UtilDateUtilities;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.model.v23.message.ORU_R01;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CMLHandler
implements MessageHandler {
    ORU_R01 msg = null;
    Logger logger = Logger.getLogger(CMLHandler.class.getName());

    @Override
    public void init(String hl7Body) throws HL7Exception {
        PipeParser p = new PipeParser();
        ((Parser)p).setValidationContext(new NoValidation());
        this.msg = (ORU_R01)((Parser)p).parse(hl7Body.replaceAll("\n", "\r\n"));
    }

    @Override
    public String getMsgType() {
        return "CML";
    }

    @Override
    public String getMsgDate() {
        try {
            return this.formatDateTime(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getObservationDateTime().getTimeOfAnEvent().getValue());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not retrieve message date", e);
            return "";
        }
    }

    @Override
    public String getMsgPriority() {
        return "";
    }

    @Override
    public int getOBRCount() {
        return this.msg.getRESPONSE().getORDER_OBSERVATIONReps();
    }

    @Override
    public int getOBXCount(int i) {
        try {
            return this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATIONReps();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public String getOBRName(int i) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBR().getUniversalServiceIdentifier().getText().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getTimeStamp(int i, int j) {
        try {
            return this.formatDateTime(this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBR().getObservationDateTime().getTimeOfAnEvent().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean isOBXAbnormal(int i, int j) {
        try {
            return this.getOBXAbnormalFlag(i, j).equals("A");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getOBXAbnormalFlag(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getAbnormalFlags(0).getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getObservationHeader(int i, int j) {
        try {
            return (this.getString(Terser.get(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 4, 0, 1, 1)) + " " + this.getString(Terser.get(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 4, 0, 2, 1)) + " " + this.getString(Terser.get(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 4, 0, 3, 1))).trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXIdentifier(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getIdentifier().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXValueType(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getValueType().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXName(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationIdentifier().getText().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXResult(int i, int j) {
        try {
            StringBuilder sb = new StringBuilder();
            int m = this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservationValue().length;
            for (int k = 0; k < m; ++k) {
                String s = Terser.get(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX(), 5, k, 1, 1);
                if (s == null) continue;
                sb.append(sb.length() == 0 ? s : "\n" + s);
            }
            String ss = sb.toString();
            return ss;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXReferenceRange(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getReferencesRange().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXUnits(int i, int j) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getUnits().getIdentifier().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOBXResultStatus(int i, int j) {
        String status = "";
        try {
            status = this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getOBX().getObservResultStatus().getValue());
            if (status.equalsIgnoreCase("I")) {
                status = "Pending";
            } else if (status.equalsIgnoreCase("F")) {
                status = "Final";
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx result status", e);
            return status;
        }
        return status;
    }

    @Override
    public int getOBXFinalResultCount() {
        int obrCount = this.getOBRCount();
        int count = 0;
        for (int i = 0; i < obrCount; ++i) {
            int obxCount = this.getOBXCount(i);
            for (int j = 0; j < obxCount; ++j) {
                if (!this.getOBXResultStatus(i, j).equals("Final")) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public List<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        try {
            for (int i = 0; i < this.msg.getRESPONSE().getORDER_OBSERVATIONReps(); ++i) {
                for (int j = 0; j < this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATIONReps(); ++j) {
                    String currentHeader;
                    if (this.getOBXName(i, j).equals("") || headers.contains(currentHeader = this.getObservationHeader(i, j))) continue;
                    headers.add(currentHeader);
                }
            }
            return headers;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not create header list", e);
            return null;
        }
    }

    @Override
    public int getOBRCommentCount(int i) {
        return 0;
    }

    @Override
    public String getOBRComment(int i, int j) {
        return "";
    }

    @Override
    public int getOBXCommentCount(int i, int j) {
        int count = 0;
        try {
            String comment;
            count = this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTEReps();
            if (count == 1 && (comment = this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE().getComment(0).getValue()) == null) {
                count = 0;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error retrieving obx comment count", e);
        }
        return count;
    }

    @Override
    public String getOBXComment(int i, int j, int k) {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(i).getOBSERVATION(j).getNTE(k).getComment(0).getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getPatientName() {
        return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getName());
    }

    @Override
    public String getFirstName() {
        return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPatientName()[0].getGivenName().getValue());
    }

    @Override
    public String getLastName() {
        return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPatientName()[0].getGivenName().getValue());
    }

    @Override
    public String getDOB() {
        try {
            return this.formatDateTime(this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getDateOfBirth().getTimeOfAnEvent().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getAge() {
        String age = "N/A";
        String dob = this.getDOB();
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date date = formatter.parse(dob);
            String serviceD = this.getServiceDate();
            Date serviceDate = null;
            if (serviceD != null && (serviceDate = UtilDateUtilities.StringToDate(serviceD)) == null) {
                serviceDate = UtilDateUtilities.getDateFromString(serviceD, "yyyy-MM-dd");
            }
            age = UtilDateUtilities.calcAgeAtDate(date, serviceDate);
        }
        catch (ParseException e) {
            this.logger.log(Level.SEVERE, "Could not get age", e);
        }
        return age;
    }

    @Override
    public String getSex() {
        return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getSex().getValue());
    }

    @Override
    public String getHealthNum() {
        return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getAlternatePatientID().getID().getValue());
    }

    @Override
    public String getFileNum() {
        return this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPid2_PatientIDExternalID().getID().getValue());
    }

    @Override
    public String getHomePhone() {
        String phone = "";
        int i = 0;
        try {
            while (!this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue()).equals("")) {
                phone = i == 0 ? this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue()) : phone + ", " + this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberHome(i).get9999999X99999CAnyText().getValue());
                ++i;
            }
            return phone;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return phone number", e);
            return "";
        }
    }

    @Override
    public String getWorkPhone() {
        String phone = "";
        int i = 0;
        try {
            while (!this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue()).equals("")) {
                phone = i == 0 ? this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue()) : phone + ", " + this.getString(this.msg.getRESPONSE().getPATIENT().getPID().getPhoneNumberBusiness(i).get9999999X99999CAnyText().getValue());
                ++i;
            }
            return phone;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return phone number", e);
            return "";
        }
    }

    @Override
    public String getPatientLocation() {
        return this.getString(this.msg.getMSH().getSendingFacility().getNamespaceID().getValue());
    }

    @Override
    public String getServiceDate() {
        try {
            return this.formatDateTime(this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getORC().getOrderEffectiveDateTime().getTimeOfAnEvent().getValue()));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getOrderStatus() {
        try {
            return this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getORC().getOrderStatus().getValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getClientRef() {
        String docNum = "";
        int i = 0;
        try {
            while (!this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i).getIDNumber().getValue()).equals("")) {
                docNum = i == 0 ? this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i).getIDNumber().getValue()) : docNum + ", " + this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i).getIDNumber().getValue());
                ++i;
            }
            return docNum;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return doctor id numbers", e);
            return "";
        }
    }

    @Override
    public String getAccessionNum() {
        String accessionNum = "";
        try {
            accessionNum = this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getORC().getPlacerOrderNumber(0).getEntityIdentifier().getValue());
            if (this.msg.getRESPONSE().getORDER_OBSERVATION(0).getORC().getFillerOrderNumber().getEntityIdentifier().getValue() != null) {
                accessionNum = accessionNum + ", " + this.getString(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getORC().getFillerOrderNumber().getEntityIdentifier().getValue());
            }
            return accessionNum;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return accession number", e);
            return "";
        }
    }

    @Override
    public String getDocName() {
        String docName = "";
        int i = 0;
        try {
            while (!this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i)).equals("")) {
                docName = i == 0 ? this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i)) : docName + ", " + this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(i));
                ++i;
            }
            return docName;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return doctor names", e);
            return "";
        }
    }

    @Override
    public String getCCDocs() {
        String docName = "";
        int i = 0;
        try {
            while (!this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i)).equals("")) {
                docName = i == 0 ? this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i)) : docName + ", " + this.getFullDocName(this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i));
                ++i;
            }
            return docName;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return cc'ed doctors", e);
            return "";
        }
    }

    @Override
    public ArrayList<String> getDocNums() {
        ArrayList<String> docNums = new ArrayList<String>();
        try {
            String id;
            String providerId = this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getOrderingProvider(0).getIDNumber().getValue();
            docNums.add(providerId);
            int i = 0;
            while ((id = this.msg.getRESPONSE().getORDER_OBSERVATION(0).getOBR().getResultCopiesTo(i).getIDNumber().getValue()) != null) {
                if (!id.equals(providerId)) {
                    docNums.add(id);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not return doctor nums", e);
        }
        return docNums;
    }

    @Override
    public String audit() {
        return "";
    }

    private String getFullDocName(XCN docSeg) {
        String docName = "";
        if (docSeg.getPrefixEgDR().getValue() != null) {
            docName = docSeg.getPrefixEgDR().getValue();
        }
        if (docSeg.getGivenName().getValue() != null) {
            docName = docName.equals("") ? docSeg.getGivenName().getValue() : docName + " " + docSeg.getGivenName().getValue();
        }
        if (docSeg.getMiddleInitialOrName().getValue() != null) {
            docName = docName.equals("") ? docSeg.getMiddleInitialOrName().getValue() : docName + " " + docSeg.getMiddleInitialOrName().getValue();
        }
        if (docSeg.getFamilyName().getValue() != null) {
            docName = docName.equals("") ? docSeg.getFamilyName().getValue() : docName + " " + docSeg.getFamilyName().getValue();
        }
        if (docSeg.getSuffixEgJRorIII().getValue() != null) {
            docName = docName.equals("") ? docSeg.getSuffixEgJRorIII().getValue() : docName + " " + docSeg.getSuffixEgJRorIII().getValue();
        }
        if (docSeg.getDegreeEgMD().getValue() != null) {
            docName = docName.equals("") ? docSeg.getDegreeEgMD().getValue() : docName + " " + docSeg.getDegreeEgMD().getValue();
        }
        return docName;
    }

    private String formatDateTime(String plain) {
        String dateFormat = "yyyyMMddHHmmss";
        dateFormat = dateFormat.substring(0, plain.length());
        String stringFormat = "yyyy-MM-dd HH:mm:ss";
        stringFormat = stringFormat.substring(0, stringFormat.lastIndexOf(dateFormat.charAt(dateFormat.length() - 1)) + 1);
        Date date = UtilDateUtilities.StringToDate(plain, dateFormat);
        return UtilDateUtilities.DateToString(date, stringFormat);
    }

    private String getString(String retrieve) {
        if (retrieve != null) {
            retrieve.replaceAll("^", " ");
            return retrieve.trim();
        }
        return "";
    }

    @Override
    public String getPrelDate() {
        return null;
    }

    @Override
    public String getOBRSpecimen(int i) {
        return null;
    }

    @Override
    public String getOBXEquipment(int i, int j) {
        return null;
    }

    @Override
    public String getOBXUserCheck(int i, int j) {
        return null;
    }

    @Override
    public String getSpecimenName(int j) {
        return null;
    }

    @Override
    public String[] getDspLines() {
        return null;
    }

    @Override
    public String getPdfFromObx55(int j) {
        return null;
    }

    @Override
    public String getPerformingOrganisation(int i, int j) {
        return null;
    }

    @Override
    public String getOBXLoincIdentifier(int i, int j) {
        return null;
    }
}

