/*
 * Decompiled with CFR 0.152.
 */
package org.ga.log.ro;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.ga.log.ro.FileSizeRolloverStrategy;
import org.ga.log.ro.RolloverStrategy;
import org.ga.log.ro.TimeOfDayRolloverStrategy;

public class RolloverManager
extends Writer {
    private static final String KEY_PREFIX = "log.";
    private static final String KEY_ROLLOVER_STRATEGY = "log.rollover";
    private static final String ROLLOVER_STRATEGY_FILESIZE = "fileSize";
    private static final String ROLLOVER_STRATEGY_TIMEOFDAY = "timeOfDay";
    private static final String KEY_ACTIVE_LOG_FILE = "log.logFile";
    private static final String KEY_ROLLOVER_LOG_FILE = "log.rollover.filename";
    private static final String KEY_ROLLOVER_DIRECTORY = "log.rollover.directory";
    private static final String KEY_ROLLOVER_PERIOD = "log.rollover.period";
    private static final String DEFAULT_ROLLOVER_PERIOD = "60";
    private final Object PRINTERS_SEMAPHORE = new Object();
    private int printerCount = 0;
    private final Object WRITER_CHANGE_GATE = new Object();
    private Writer writer;
    private final StringWriter tempWriter = new StringWriter(1024);
    private RolloverStrategy strategy;
    private String currentRolloverStrategyName;
    private File currentActiveLogFile;
    private File currentActiveLogFileDirectory;
    private File rolloverDirectory;
    private MessageFormat rolloverLogFileFormat;
    private RandomAccessFile fileOut;
    private boolean strategySetProgramatically = false;
    private long rolloverPeriod;
    private Timer timer;
    private int uniqueFileId = 0;
    private final ErrorReporter errorReporter;

    public RolloverManager(Properties properties, ErrorReporter errorReporter) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null.");
        }
        this.errorReporter = errorReporter;
        this.configure(properties);
    }

    public void configure(Properties properties) throws IOException {
        this.configureStrategy(properties);
        this.configureWriter(properties);
    }

    private void configureStrategy(Properties properties) throws IOException {
        RolloverStrategy newStrategy;
        boolean strategyChanged;
        if (this.strategySetProgramatically) {
            return;
        }
        String rolloverStrategyString = properties.getProperty(KEY_ROLLOVER_STRATEGY);
        if (rolloverStrategyString == null) {
            throw new IOException("RolloverManger created, but rollover property not specified.");
        }
        if ((rolloverStrategyString = rolloverStrategyString.trim()).length() == 0) {
            throw new IOException("RolloverManger created, but rollover property not specified.");
        }
        boolean bl = strategyChanged = !rolloverStrategyString.equals(this.currentRolloverStrategyName);
        if (strategyChanged) {
            try {
                if (ROLLOVER_STRATEGY_FILESIZE.equals(rolloverStrategyString)) {
                    newStrategy = new FileSizeRolloverStrategy();
                }
                if (ROLLOVER_STRATEGY_TIMEOFDAY.equals(rolloverStrategyString)) {
                    newStrategy = new TimeOfDayRolloverStrategy();
                }
                try {
                    Class<?> strategyClass = Class.forName(rolloverStrategyString);
                    Object strategyObject = strategyClass.newInstance();
                    if (!(strategyObject instanceof RolloverStrategy)) {
                        throw new IOException(strategyClass.getName() + " is not a RolloverStrategy");
                    }
                    newStrategy = (RolloverStrategy)strategyObject;
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("Class '" + rolloverStrategyString + "' not found: " + e);
                }
                catch (InstantiationException e) {
                    throw new IOException("Failed to create an instance of " + rolloverStrategyString + ": " + e);
                }
                catch (IllegalAccessException e) {
                    throw new IOException("Failed to create an instance of " + rolloverStrategyString + ": " + e);
                }
            }
            catch (IOException e) {
                throw new IOException("Error creating RolloverStrategy: " + e);
            }
        } else {
            newStrategy = this.strategy;
        }
        try {
            newStrategy.configure(Collections.unmodifiableMap(properties));
        }
        catch (IOException e) {
            throw new IOException("Error configuring RolloverStrategy: " + e);
        }
        this.strategy = newStrategy;
        this.currentRolloverStrategyName = rolloverStrategyString;
    }

    private void configureWriter(Properties properties) throws IOException {
        boolean uniqueIdUsedInPattern;
        long newRolloverPeriod;
        MessageFormat newRolloverLogFileNameFormat;
        String newActiveLogFileName = properties.getProperty(KEY_ACTIVE_LOG_FILE);
        if (newActiveLogFileName == null) {
            throw new IOException("RolloverManager created but no active log file name specified.");
        }
        File newActiveLogFile = new File(newActiveLogFileName.trim()).getAbsoluteFile();
        if (newActiveLogFile.isDirectory()) {
            throw new IOException("The specified active log file name already exists as a directory.");
        }
        File newActiveLogFileDirectory = newActiveLogFile.getParentFile();
        if (newActiveLogFileDirectory == null) {
            throw new IOException("Caanot access the active log file's parent directory.");
        }
        newActiveLogFileDirectory.mkdirs();
        String newRolloverLogFileNamePattern = properties.getProperty(KEY_ROLLOVER_LOG_FILE);
        if (newRolloverLogFileNamePattern == null) {
            newRolloverLogFileNamePattern = "{1}-" + newActiveLogFile.getName();
        }
        newRolloverLogFileNamePattern = newRolloverLogFileNamePattern.trim();
        try {
            newRolloverLogFileNameFormat = new MessageFormat(newRolloverLogFileNamePattern);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Illegal pattern provided for rollover log file name: " + e.getMessage());
        }
        String newRolloverDirectoryName = properties.getProperty(KEY_ROLLOVER_DIRECTORY);
        File newRolloverDirectory = newRolloverDirectoryName != null ? new File(newRolloverDirectoryName.trim()).getAbsoluteFile() : newActiveLogFileDirectory;
        if (newRolloverDirectory.exists() && !newRolloverDirectory.isDirectory()) {
            throw new IOException("The location specified for storing rolled log files is not a directory: " + newRolloverDirectory);
        }
        String rolloverPeriodString = (String)properties.get(KEY_ROLLOVER_PERIOD);
        if (rolloverPeriodString == null) {
            rolloverPeriodString = DEFAULT_ROLLOVER_PERIOD;
        }
        if ((rolloverPeriodString = rolloverPeriodString.trim()).length() == 0) {
            rolloverPeriodString = DEFAULT_ROLLOVER_PERIOD;
        }
        try {
            newRolloverPeriod = Long.parseLong(rolloverPeriodString);
            if (newRolloverPeriod < 1L) {
                throw new NumberFormatException("Must be greater than 0");
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid rollover period specified: " + rolloverPeriodString + " (" + e.getMessage() + ")");
        }
        Format[] formats = newRolloverLogFileNameFormat.getFormatsByArgumentIndex();
        boolean bl = uniqueIdUsedInPattern = formats.length > 1;
        if (uniqueIdUsedInPattern) {
            String[] filenames = newRolloverDirectory.list();
            int maximumFileId = 0;
            for (int i = 0; filenames != null && i < filenames.length; ++i) {
                String filename = filenames[i];
                try {
                    String uniqueFileIdString;
                    int parsedFileId;
                    Object[] parameters = newRolloverLogFileNameFormat.parse(filename);
                    if (parameters.length <= 1 || parameters[1] == null || (parsedFileId = Integer.parseInt(uniqueFileIdString = (String)parameters[1], 16)) <= maximumFileId) continue;
                    maximumFileId = parsedFileId;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.uniqueFileId = maximumFileId + 1;
        }
        this.rolloverDirectory = newRolloverDirectory;
        this.rolloverLogFileFormat = newRolloverLogFileNameFormat;
        if (!newActiveLogFile.equals(this.currentActiveLogFile)) {
            this.openWriter(newActiveLogFile, newActiveLogFileDirectory);
            this.currentActiveLogFile = newActiveLogFile;
            this.currentActiveLogFileDirectory = newActiveLogFileDirectory;
        }
        if (this.timer == null || newRolloverPeriod != this.rolloverPeriod) {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new RolloverTask(), 0L, newRolloverPeriod * 1000L);
            this.rolloverPeriod = newRolloverPeriod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openWriter(File newActiveLogFile, File activeLogFileDirectory) throws IOException {
        Object object = this.WRITER_CHANGE_GATE;
        synchronized (object) {
            Object object2 = this.PRINTERS_SEMAPHORE;
            synchronized (object2) {
                if (this.printerCount != 0) {
                    try {
                        this.PRINTERS_SEMAPHORE.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException("Interrupted while attempting to configure writer");
                    }
                }
                if (this.writer != this.tempWriter) {
                    if (this.writer != null) {
                        try {
                            this.writer.close();
                        }
                        catch (IOException e) {
                            throw new IOException("Failed to close open file: " + e);
                        }
                    }
                    RandomAccessFile newFileOut = new RandomAccessFile(newActiveLogFile, "rws");
                    FileChannel channel = newFileOut.getChannel();
                    long initialChannelSize = channel.size();
                    newFileOut.seek(initialChannelSize);
                    Writer newFileWriter = Channels.newWriter((WritableByteChannel)newFileOut.getChannel(), "UTF-8");
                    this.storeFileCreationTimeIfNecessary(activeLogFileDirectory, newActiveLogFile);
                    this.fileOut = newFileOut;
                    this.writer = newFileWriter;
                }
            }
        }
    }

    private void storeFileCreationTimeIfNecessary(File activeLogFileDirectory, File newActiveLogFile) throws IOException {
        long creationTime = System.currentTimeMillis();
        try {
            boolean recordCreationTime;
            File creationTimeFile = this.getCreationTimeFile(activeLogFileDirectory, newActiveLogFile);
            boolean bl = recordCreationTime = !creationTimeFile.exists();
            if (recordCreationTime) {
                FileWriter creationTimeFileOut = new FileWriter(creationTimeFile);
                creationTimeFileOut.write(String.valueOf(creationTime));
                creationTimeFileOut.close();
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to write file creation time: " + e);
        }
    }

    private long readCreationTime() throws IOException {
        try {
            File creationTimeFile = this.getCreationTimeFile(this.currentActiveLogFileDirectory, this.currentActiveLogFile);
            if (!creationTimeFile.exists()) {
                this.storeFileCreationTimeIfNecessary(this.currentActiveLogFileDirectory, this.currentActiveLogFile);
            }
            FileReader fileIn = new FileReader(creationTimeFile);
            BufferedReader in = new BufferedReader(fileIn);
            String firstLine = in.readLine();
            in.close();
            return Long.parseLong(firstLine);
        }
        catch (IOException e) {
            throw new IOException("Error reading creation time file: " + e);
        }
        catch (NumberFormatException e) {
            throw new IOException("Error reading creation time: " + e);
        }
    }

    private File getCreationTimeFile(File activeLogFileDirectory, File newActiveLogFile) {
        return new File(activeLogFileDirectory, newActiveLogFile.getName() + "-CREATED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.WRITER_CHANGE_GATE;
        synchronized (object) {
            Object object2 = this.PRINTERS_SEMAPHORE;
            synchronized (object2) {
                if (this.printerCount != 0) {
                    try {
                        this.PRINTERS_SEMAPHORE.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException("Interrupted while attempting to configure writer");
                    }
                }
                this.writer = this.tempWriter;
            }
            this.timer.cancel();
            try {
                this.writer.close();
            }
            catch (IOException e) {
                this.reportError("Error closing RolloverManager's writer", e, true);
            }
            try {
                this.fileOut.close();
            }
            catch (IOException e) {
                this.reportError("Error closing RolloverManager's file", e, true);
            }
        }
    }

    protected void reportError(String description, IOException e, boolean printExceptionType) {
        if (this.errorReporter != null) {
            this.errorReporter.error(description, e, printExceptionType);
        }
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.WRITER_CHANGE_GATE;
        synchronized (object) {
        }
        object = this.PRINTERS_SEMAPHORE;
        synchronized (object) {
            ++this.printerCount;
        }
        try {
            this.writer.write(cbuf, off, len);
            this.writer.flush();
        }
        finally {
            object = this.PRINTERS_SEMAPHORE;
            synchronized (object) {
                --this.printerCount;
                if (this.printerCount == 0) {
                    this.PRINTERS_SEMAPHORE.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rolloverIfNecessary() throws IOException {
        FileChannel activeFileChannel;
        long fileLength;
        long creationTime = this.readCreationTime();
        Date creationDate = new Date(creationTime);
        boolean rolloverNow = this.strategy.rolloverNow(creationDate, fileLength = (activeFileChannel = this.fileOut.getChannel()).size());
        if (rolloverNow) {
            Object object = this.WRITER_CHANGE_GATE;
            synchronized (object) {
                Object object2 = this.PRINTERS_SEMAPHORE;
                synchronized (object2) {
                    if (this.printerCount != 0) {
                        try {
                            this.PRINTERS_SEMAPHORE.wait();
                        }
                        catch (InterruptedException e) {
                            throw new IllegalStateException("Interrupted while attempting to configure writer");
                        }
                    }
                    this.writer = this.tempWriter;
                }
            }
            int fileIdNumber = this.uniqueFileId++;
            StringBuffer fileIdString = new StringBuffer();
            fileIdString.append(Integer.toHexString(fileIdNumber).toUpperCase());
            char[] zeroes = new char[8 - fileIdString.length()];
            Arrays.fill(zeroes, '0');
            fileIdString.insert(0, zeroes);
            String rolloverFileName = this.rolloverLogFileFormat.format(new Object[]{new Date(), fileIdString.toString()});
            if (!this.rolloverDirectory.exists()) {
                this.rolloverDirectory.mkdirs();
            }
            File rolloverFile = new File(this.rolloverDirectory, rolloverFileName);
            FileOutputStream rolloverOut = new FileOutputStream(rolloverFile, false);
            FileChannel rolloverChannel = rolloverOut.getChannel();
            activeFileChannel.transferTo(0L, activeFileChannel.size(), rolloverChannel);
            rolloverOut.close();
            activeFileChannel.truncate(0L);
            this.fileOut.seek(0L);
            Writer newFileWriter = Channels.newWriter((WritableByteChannel)activeFileChannel, "UTF-8");
            File creationTimeFile = this.getCreationTimeFile(this.currentActiveLogFileDirectory, this.currentActiveLogFile);
            creationTimeFile.delete();
            this.storeFileCreationTimeIfNecessary(this.currentActiveLogFileDirectory, this.currentActiveLogFile);
            Object object3 = this.WRITER_CHANGE_GATE;
            synchronized (object3) {
                Object object4 = this.PRINTERS_SEMAPHORE;
                synchronized (object4) {
                    if (this.printerCount != 0) {
                        try {
                            this.PRINTERS_SEMAPHORE.wait();
                        }
                        catch (InterruptedException e) {
                            throw new IllegalStateException("Interrupted while attempting to configure writer");
                        }
                    }
                    this.writer = newFileWriter;
                    StringBuffer tempBuffer = this.tempWriter.getBuffer();
                    newFileWriter.write(tempBuffer.toString());
                    tempBuffer.delete(0, tempBuffer.length());
                }
            }
        }
    }

    public RolloverStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(RolloverStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("strategy cannot be null.");
        }
        this.strategy = strategy;
        this.strategySetProgramatically = true;
    }

    public static Writer createRolloverManager(Properties properties, ErrorReporter errorReporter) throws IOException {
        return new RolloverManager(properties, errorReporter);
    }

    public static interface ErrorReporter {
        public void error(String var1, Throwable var2, boolean var3);
    }

    protected final class RolloverTask
    extends TimerTask {
        protected RolloverTask() {
        }

        @Override
        public void run() {
            try {
                RolloverManager.this.rolloverIfNecessary();
            }
            catch (IOException e) {
                RolloverManager.this.reportError("SimpleLog ERROR: Failed to check or attempt rollover", e, true);
            }
        }
    }
}

