/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder.support;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.builder.Expression;
import ca.uhn.hl7v2.validation.builder.Predicate;
import ca.uhn.hl7v2.validation.builder.PredicateMessageRule;
import java.io.Serializable;
import java.util.StringTokenizer;

public class TerserMessageRule
extends PredicateMessageRule {
    public TerserMessageRule(String terserExpression, Predicate predicate) {
        super(predicate, new TerserExpression(terserExpression));
    }

    private static class TerserExpression
    implements Expression<Message>,
    Serializable {
        private String expression;

        public TerserExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public Object evaluate(Message msg) throws HL7Exception {
            return new Terser(msg).get(this.expression);
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public Location getLocation(Message msg) throws HL7Exception {
            Terser t = new Terser(msg);
            StringTokenizer tok = new StringTokenizer(this.expression, "-", false);
            Segment segment = t.getSegment(tok.nextToken());
            Location location = new Location().withSegmentName(segment.getName()).withFieldIndizes(Terser.getIndices(this.expression));
            return location;
        }
    }
}

