/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CP;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class GP1
extends AbstractSegment {
    public GP1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Type of Bill Code");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Revenue Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Overall Claim Disposition Code");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "OCE Edits per Visit Code");
            this.add(CP.class, false, 1, 0, new Object[]{this.getMessage()}, "Outlier Cost");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating GP1 - this is probably a bug in the source code generator.", e);
        }
    }

    public CWE getTypeOfBillCode() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getGp11_TypeOfBillCode() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE[] getRevenueCode() {
        CWE[] retVal = (CWE[])this.getTypedField(2, new CWE[0]);
        return retVal;
    }

    public CWE[] getGp12_RevenueCode() {
        CWE[] retVal = (CWE[])this.getTypedField(2, new CWE[0]);
        return retVal;
    }

    public int getRevenueCodeReps() {
        return this.getReps(2);
    }

    public CWE getRevenueCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public CWE getGp12_RevenueCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getGp12_RevenueCodeReps() {
        return this.getReps(2);
    }

    public CWE insertRevenueCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE insertGp12_RevenueCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(2, rep);
    }

    public CWE removeRevenueCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE removeGp12_RevenueCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(2, rep);
    }

    public CWE getOverallClaimDispositionCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getGp13_OverallClaimDispositionCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE[] getOCEEditsPerVisitCode() {
        CWE[] retVal = (CWE[])this.getTypedField(4, new CWE[0]);
        return retVal;
    }

    public CWE[] getGp14_OCEEditsPerVisitCode() {
        CWE[] retVal = (CWE[])this.getTypedField(4, new CWE[0]);
        return retVal;
    }

    public int getOCEEditsPerVisitCodeReps() {
        return this.getReps(4);
    }

    public CWE getOCEEditsPerVisitCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public CWE getGp14_OCEEditsPerVisitCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getGp14_OCEEditsPerVisitCodeReps() {
        return this.getReps(4);
    }

    public CWE insertOCEEditsPerVisitCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE insertGp14_OCEEditsPerVisitCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE removeOCEEditsPerVisitCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE removeGp14_OCEEditsPerVisitCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CP getOutlierCost() {
        CP retVal = (CP)this.getTypedField(5, 0);
        return retVal;
    }

    public CP getGp15_OutlierCost() {
        CP retVal = (CP)this.getTypedField(5, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CP(this.getMessage());
            }
        }
        return null;
    }
}

