/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.EI;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.NM;
import ca.uhn.hl7v2.model.v281.datatype.SNM;
import ca.uhn.hl7v2.model.v281.datatype.ST;

public class XTN
extends AbstractComposite {
    private Type[] data;

    public XTN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[18];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new ID(this.getMessage(), 201);
        this.data[2] = new ID(this.getMessage(), 202);
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new SNM(this.getMessage());
        this.data[5] = new SNM(this.getMessage());
        this.data[6] = new SNM(this.getMessage());
        this.data[7] = new SNM(this.getMessage());
        this.data[8] = new ST(this.getMessage());
        this.data[9] = new ST(this.getMessage());
        this.data[10] = new ST(this.getMessage());
        this.data[11] = new ST(this.getMessage());
        this.data[12] = new DTM(this.getMessage());
        this.data[13] = new DTM(this.getMessage());
        this.data[14] = new CWE(this.getMessage());
        this.data[15] = new CWE(this.getMessage());
        this.data[16] = new EI(this.getMessage());
        this.data[17] = new NM(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getTelephoneNumber() {
        return this.getTyped(0, ST.class);
    }

    public ST getXtn1_TelephoneNumber() {
        return this.getTyped(0, ST.class);
    }

    public ID getTelecommunicationUseCode() {
        return this.getTyped(1, ID.class);
    }

    public ID getXtn2_TelecommunicationUseCode() {
        return this.getTyped(1, ID.class);
    }

    public ID getTelecommunicationEquipmentType() {
        return this.getTyped(2, ID.class);
    }

    public ID getXtn3_TelecommunicationEquipmentType() {
        return this.getTyped(2, ID.class);
    }

    public ST getCommunicationAddress() {
        return this.getTyped(3, ST.class);
    }

    public ST getXtn4_CommunicationAddress() {
        return this.getTyped(3, ST.class);
    }

    public SNM getCountryCode() {
        return this.getTyped(4, SNM.class);
    }

    public SNM getXtn5_CountryCode() {
        return this.getTyped(4, SNM.class);
    }

    public SNM getAreaCityCode() {
        return this.getTyped(5, SNM.class);
    }

    public SNM getXtn6_AreaCityCode() {
        return this.getTyped(5, SNM.class);
    }

    public SNM getLocalNumber() {
        return this.getTyped(6, SNM.class);
    }

    public SNM getXtn7_LocalNumber() {
        return this.getTyped(6, SNM.class);
    }

    public SNM getExtension() {
        return this.getTyped(7, SNM.class);
    }

    public SNM getXtn8_Extension() {
        return this.getTyped(7, SNM.class);
    }

    public ST getAnyText() {
        return this.getTyped(8, ST.class);
    }

    public ST getXtn9_AnyText() {
        return this.getTyped(8, ST.class);
    }

    public ST getExtensionPrefix() {
        return this.getTyped(9, ST.class);
    }

    public ST getXtn10_ExtensionPrefix() {
        return this.getTyped(9, ST.class);
    }

    public ST getSpeedDialCode() {
        return this.getTyped(10, ST.class);
    }

    public ST getXtn11_SpeedDialCode() {
        return this.getTyped(10, ST.class);
    }

    public ST getUnformattedTelephoneNumber() {
        return this.getTyped(11, ST.class);
    }

    public ST getXtn12_UnformattedTelephoneNumber() {
        return this.getTyped(11, ST.class);
    }

    public DTM getEffectiveStartDate() {
        return this.getTyped(12, DTM.class);
    }

    public DTM getXtn13_EffectiveStartDate() {
        return this.getTyped(12, DTM.class);
    }

    public DTM getExpirationDate() {
        return this.getTyped(13, DTM.class);
    }

    public DTM getXtn14_ExpirationDate() {
        return this.getTyped(13, DTM.class);
    }

    public CWE getExpirationReason() {
        return this.getTyped(14, CWE.class);
    }

    public CWE getXtn15_ExpirationReason() {
        return this.getTyped(14, CWE.class);
    }

    public CWE getProtectionCode() {
        return this.getTyped(15, CWE.class);
    }

    public CWE getXtn16_ProtectionCode() {
        return this.getTyped(15, CWE.class);
    }

    public EI getSharedTelecommunicationIdentifier() {
        return this.getTyped(16, EI.class);
    }

    public EI getXtn17_SharedTelecommunicationIdentifier() {
        return this.getTyped(16, EI.class);
    }

    public NM getPreferenceOrder() {
        return this.getTyped(17, NM.class);
    }

    public NM getXtn18_PreferenceOrder() {
        return this.getTyped(17, NM.class);
    }
}

