/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CNE;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.EI;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.NULLDT;
import ca.uhn.hl7v2.model.v28.datatype.PL;
import ca.uhn.hl7v2.model.v28.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PR1
extends AbstractSegment {
    public PR1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - PR1");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Procedure Coding Method");
            this.add(CNE.class, true, 1, 0, new Object[]{this.getMessage()}, "Procedure Code");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Procedure Description");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Procedure Date/Time");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Procedure Functional Type");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Procedure Minutes");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Anesthesiologist");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Anesthesia Code");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Anesthesia Minutes");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Surgeon");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Procedure Practitioner");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Consent Code");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Procedure Priority");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Associated Diagnosis Code");
            this.add(CNE.class, false, 0, 0, new Object[]{this.getMessage()}, "Procedure Code Modifier");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Procedure DRG Type");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Tissue Type Code");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Procedure Identifier");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(206)}, "Procedure Action Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "DRG Procedure Determination Status");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "DRG Procedure Relevance");
            this.add(PL.class, false, 0, 0, new Object[]{this.getMessage()}, "Treating Organizational Unit");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Respiratory Within Surgery");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Parent Procedure ID");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PR1 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDPR1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPr11_SetIDPR1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public NULLDT getProcedureCodingMethod() {
        NULLDT retVal = (NULLDT)this.getTypedField(2, 0);
        return retVal;
    }

    public NULLDT getPr12_ProcedureCodingMethod() {
        NULLDT retVal = (NULLDT)this.getTypedField(2, 0);
        return retVal;
    }

    public CNE getProcedureCode() {
        CNE retVal = (CNE)this.getTypedField(3, 0);
        return retVal;
    }

    public CNE getPr13_ProcedureCode() {
        CNE retVal = (CNE)this.getTypedField(3, 0);
        return retVal;
    }

    public NULLDT getProcedureDescription() {
        NULLDT retVal = (NULLDT)this.getTypedField(4, 0);
        return retVal;
    }

    public NULLDT getPr14_ProcedureDescription() {
        NULLDT retVal = (NULLDT)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getProcedureDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getPr15_ProcedureDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getProcedureFunctionalType() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getPr16_ProcedureFunctionalType() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getProcedureMinutes() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getPr17_ProcedureMinutes() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NULLDT getAnesthesiologist() {
        NULLDT retVal = (NULLDT)this.getTypedField(8, 0);
        return retVal;
    }

    public NULLDT getPr18_Anesthesiologist() {
        NULLDT retVal = (NULLDT)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getAnesthesiaCode() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getPr19_AnesthesiaCode() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getAnesthesiaMinutes() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getPr110_AnesthesiaMinutes() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NULLDT getSurgeon() {
        NULLDT retVal = (NULLDT)this.getTypedField(11, 0);
        return retVal;
    }

    public NULLDT getPr111_Surgeon() {
        NULLDT retVal = (NULLDT)this.getTypedField(11, 0);
        return retVal;
    }

    public NULLDT getProcedurePractitioner() {
        NULLDT retVal = (NULLDT)this.getTypedField(12, 0);
        return retVal;
    }

    public NULLDT getPr112_ProcedurePractitioner() {
        NULLDT retVal = (NULLDT)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getConsentCode() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getPr113_ConsentCode() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getProcedurePriority() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getPr114_ProcedurePriority() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getAssociatedDiagnosisCode() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getPr115_AssociatedDiagnosisCode() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CNE[] getProcedureCodeModifier() {
        CNE[] retVal = (CNE[])this.getTypedField(16, new CNE[0]);
        return retVal;
    }

    public CNE[] getPr116_ProcedureCodeModifier() {
        CNE[] retVal = (CNE[])this.getTypedField(16, new CNE[0]);
        return retVal;
    }

    public int getProcedureCodeModifierReps() {
        return this.getReps(16);
    }

    public CNE getProcedureCodeModifier(int rep) {
        CNE retVal = (CNE)this.getTypedField(16, rep);
        return retVal;
    }

    public CNE getPr116_ProcedureCodeModifier(int rep) {
        CNE retVal = (CNE)this.getTypedField(16, rep);
        return retVal;
    }

    public int getPr116_ProcedureCodeModifierReps() {
        return this.getReps(16);
    }

    public CNE insertProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(16, rep);
    }

    public CNE insertPr116_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(16, rep);
    }

    public CNE removeProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(16, rep);
    }

    public CNE removePr116_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(16, rep);
    }

    public CWE getProcedureDRGType() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getPr117_ProcedureDRGType() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE[] getTissueTypeCode() {
        CWE[] retVal = (CWE[])this.getTypedField(18, new CWE[0]);
        return retVal;
    }

    public CWE[] getPr118_TissueTypeCode() {
        CWE[] retVal = (CWE[])this.getTypedField(18, new CWE[0]);
        return retVal;
    }

    public int getTissueTypeCodeReps() {
        return this.getReps(18);
    }

    public CWE getTissueTypeCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public CWE getPr118_TissueTypeCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public int getPr118_TissueTypeCodeReps() {
        return this.getReps(18);
    }

    public CWE insertTissueTypeCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE insertPr118_TissueTypeCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE removeTissueTypeCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public CWE removePr118_TissueTypeCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public EI getProcedureIdentifier() {
        EI retVal = (EI)this.getTypedField(19, 0);
        return retVal;
    }

    public EI getPr119_ProcedureIdentifier() {
        EI retVal = (EI)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getProcedureActionCode() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getPr120_ProcedureActionCode() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE getDRGProcedureDeterminationStatus() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getPr121_DRGProcedureDeterminationStatus() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getDRGProcedureRelevance() {
        CWE retVal = (CWE)this.getTypedField(22, 0);
        return retVal;
    }

    public CWE getPr122_DRGProcedureRelevance() {
        CWE retVal = (CWE)this.getTypedField(22, 0);
        return retVal;
    }

    public PL[] getTreatingOrganizationalUnit() {
        PL[] retVal = (PL[])this.getTypedField(23, new PL[0]);
        return retVal;
    }

    public PL[] getPr123_TreatingOrganizationalUnit() {
        PL[] retVal = (PL[])this.getTypedField(23, new PL[0]);
        return retVal;
    }

    public int getTreatingOrganizationalUnitReps() {
        return this.getReps(23);
    }

    public PL getTreatingOrganizationalUnit(int rep) {
        PL retVal = (PL)this.getTypedField(23, rep);
        return retVal;
    }

    public PL getPr123_TreatingOrganizationalUnit(int rep) {
        PL retVal = (PL)this.getTypedField(23, rep);
        return retVal;
    }

    public int getPr123_TreatingOrganizationalUnitReps() {
        return this.getReps(23);
    }

    public PL insertTreatingOrganizationalUnit(int rep) throws HL7Exception {
        return (PL)super.insertRepetition(23, rep);
    }

    public PL insertPr123_TreatingOrganizationalUnit(int rep) throws HL7Exception {
        return (PL)super.insertRepetition(23, rep);
    }

    public PL removeTreatingOrganizationalUnit(int rep) throws HL7Exception {
        return (PL)super.removeRepetition(23, rep);
    }

    public PL removePr123_TreatingOrganizationalUnit(int rep) throws HL7Exception {
        return (PL)super.removeRepetition(23, rep);
    }

    public ID getRespiratoryWithinSurgery() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getPr124_RespiratoryWithinSurgery() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public EI getParentProcedureID() {
        EI retVal = (EI)this.getTypedField(25, 0);
        return retVal;
    }

    public EI getPr125_ParentProcedureID() {
        EI retVal = (EI)this.getTypedField(25, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new NULLDT(this.getMessage());
            }
            case 2: {
                return new CNE(this.getMessage());
            }
            case 3: {
                return new NULLDT(this.getMessage());
            }
            case 4: {
                return new DTM(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new NULLDT(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new NULLDT(this.getMessage());
            }
            case 11: {
                return new NULLDT(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new NM(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new CNE(this.getMessage());
            }
            case 16: {
                return new CWE(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new EI(this.getMessage());
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 20: {
                return new CWE(this.getMessage());
            }
            case 21: {
                return new CWE(this.getMessage());
            }
            case 22: {
                return new PL(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 24: {
                return new EI(this.getMessage());
            }
        }
        return null;
    }
}

