/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v28.group.CCM_I21_APPOINTMENT_HISTORY;
import ca.uhn.hl7v2.model.v28.group.CCM_I21_CLINICAL_HISTORY;
import ca.uhn.hl7v2.model.v28.group.CCM_I21_GOAL;
import ca.uhn.hl7v2.model.v28.group.CCM_I21_INSURANCE;
import ca.uhn.hl7v2.model.v28.group.CCM_I21_MEDICATION_HISTORY;
import ca.uhn.hl7v2.model.v28.group.CCM_I21_PATHWAY;
import ca.uhn.hl7v2.model.v28.group.CCM_I21_PATIENT_VISITS;
import ca.uhn.hl7v2.model.v28.group.CCM_I21_PROBLEM;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.NK1;
import ca.uhn.hl7v2.model.v28.segment.PD1;
import ca.uhn.hl7v2.model.v28.segment.PID;
import ca.uhn.hl7v2.model.v28.segment.REL;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCM_I21
extends AbstractMessage {
    public CCM_I21() {
        this(new DefaultModelClassFactory());
    }

    public CCM_I21(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NK1.class, false, true);
            this.add(CCM_I21_INSURANCE.class, false, true);
            this.add(CCM_I21_APPOINTMENT_HISTORY.class, false, true);
            this.add(CCM_I21_CLINICAL_HISTORY.class, false, true);
            this.add(CCM_I21_PATIENT_VISITS.class, true, true);
            this.add(CCM_I21_MEDICATION_HISTORY.class, false, true);
            this.add(CCM_I21_PROBLEM.class, false, true);
            this.add(CCM_I21_GOAL.class, false, true);
            this.add(CCM_I21_PATHWAY.class, false, true);
            this.add(REL.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCM_I21 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return this.getTyped("PD1", PD1.class);
    }

    public NK1 getNK1() {
        return this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public CCM_I21_INSURANCE getINSURANCE() {
        return this.getTyped("INSURANCE", CCM_I21_INSURANCE.class);
    }

    public CCM_I21_INSURANCE getINSURANCE(int rep) {
        return this.getTyped("INSURANCE", rep, CCM_I21_INSURANCE.class);
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<CCM_I21_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", CCM_I21_INSURANCE.class);
    }

    public void insertINSURANCE(CCM_I21_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", structure, rep);
    }

    public CCM_I21_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (CCM_I21_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public CCM_I21_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (CCM_I21_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public CCM_I21_APPOINTMENT_HISTORY getAPPOINTMENT_HISTORY() {
        return this.getTyped("APPOINTMENT_HISTORY", CCM_I21_APPOINTMENT_HISTORY.class);
    }

    public CCM_I21_APPOINTMENT_HISTORY getAPPOINTMENT_HISTORY(int rep) {
        return this.getTyped("APPOINTMENT_HISTORY", rep, CCM_I21_APPOINTMENT_HISTORY.class);
    }

    public int getAPPOINTMENT_HISTORYReps() {
        return this.getReps("APPOINTMENT_HISTORY");
    }

    public List<CCM_I21_APPOINTMENT_HISTORY> getAPPOINTMENT_HISTORYAll() throws HL7Exception {
        return this.getAllAsList("APPOINTMENT_HISTORY", CCM_I21_APPOINTMENT_HISTORY.class);
    }

    public void insertAPPOINTMENT_HISTORY(CCM_I21_APPOINTMENT_HISTORY structure, int rep) throws HL7Exception {
        super.insertRepetition("APPOINTMENT_HISTORY", structure, rep);
    }

    public CCM_I21_APPOINTMENT_HISTORY insertAPPOINTMENT_HISTORY(int rep) throws HL7Exception {
        return (CCM_I21_APPOINTMENT_HISTORY)super.insertRepetition("APPOINTMENT_HISTORY", rep);
    }

    public CCM_I21_APPOINTMENT_HISTORY removeAPPOINTMENT_HISTORY(int rep) throws HL7Exception {
        return (CCM_I21_APPOINTMENT_HISTORY)super.removeRepetition("APPOINTMENT_HISTORY", rep);
    }

    public CCM_I21_CLINICAL_HISTORY getCLINICAL_HISTORY() {
        return this.getTyped("CLINICAL_HISTORY", CCM_I21_CLINICAL_HISTORY.class);
    }

    public CCM_I21_CLINICAL_HISTORY getCLINICAL_HISTORY(int rep) {
        return this.getTyped("CLINICAL_HISTORY", rep, CCM_I21_CLINICAL_HISTORY.class);
    }

    public int getCLINICAL_HISTORYReps() {
        return this.getReps("CLINICAL_HISTORY");
    }

    public List<CCM_I21_CLINICAL_HISTORY> getCLINICAL_HISTORYAll() throws HL7Exception {
        return this.getAllAsList("CLINICAL_HISTORY", CCM_I21_CLINICAL_HISTORY.class);
    }

    public void insertCLINICAL_HISTORY(CCM_I21_CLINICAL_HISTORY structure, int rep) throws HL7Exception {
        super.insertRepetition("CLINICAL_HISTORY", structure, rep);
    }

    public CCM_I21_CLINICAL_HISTORY insertCLINICAL_HISTORY(int rep) throws HL7Exception {
        return (CCM_I21_CLINICAL_HISTORY)super.insertRepetition("CLINICAL_HISTORY", rep);
    }

    public CCM_I21_CLINICAL_HISTORY removeCLINICAL_HISTORY(int rep) throws HL7Exception {
        return (CCM_I21_CLINICAL_HISTORY)super.removeRepetition("CLINICAL_HISTORY", rep);
    }

    public CCM_I21_PATIENT_VISITS getPATIENT_VISITS() {
        return this.getTyped("PATIENT_VISITS", CCM_I21_PATIENT_VISITS.class);
    }

    public CCM_I21_PATIENT_VISITS getPATIENT_VISITS(int rep) {
        return this.getTyped("PATIENT_VISITS", rep, CCM_I21_PATIENT_VISITS.class);
    }

    public int getPATIENT_VISITSReps() {
        return this.getReps("PATIENT_VISITS");
    }

    public List<CCM_I21_PATIENT_VISITS> getPATIENT_VISITSAll() throws HL7Exception {
        return this.getAllAsList("PATIENT_VISITS", CCM_I21_PATIENT_VISITS.class);
    }

    public void insertPATIENT_VISITS(CCM_I21_PATIENT_VISITS structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_VISITS", structure, rep);
    }

    public CCM_I21_PATIENT_VISITS insertPATIENT_VISITS(int rep) throws HL7Exception {
        return (CCM_I21_PATIENT_VISITS)super.insertRepetition("PATIENT_VISITS", rep);
    }

    public CCM_I21_PATIENT_VISITS removePATIENT_VISITS(int rep) throws HL7Exception {
        return (CCM_I21_PATIENT_VISITS)super.removeRepetition("PATIENT_VISITS", rep);
    }

    public CCM_I21_MEDICATION_HISTORY getMEDICATION_HISTORY() {
        return this.getTyped("MEDICATION_HISTORY", CCM_I21_MEDICATION_HISTORY.class);
    }

    public CCM_I21_MEDICATION_HISTORY getMEDICATION_HISTORY(int rep) {
        return this.getTyped("MEDICATION_HISTORY", rep, CCM_I21_MEDICATION_HISTORY.class);
    }

    public int getMEDICATION_HISTORYReps() {
        return this.getReps("MEDICATION_HISTORY");
    }

    public List<CCM_I21_MEDICATION_HISTORY> getMEDICATION_HISTORYAll() throws HL7Exception {
        return this.getAllAsList("MEDICATION_HISTORY", CCM_I21_MEDICATION_HISTORY.class);
    }

    public void insertMEDICATION_HISTORY(CCM_I21_MEDICATION_HISTORY structure, int rep) throws HL7Exception {
        super.insertRepetition("MEDICATION_HISTORY", structure, rep);
    }

    public CCM_I21_MEDICATION_HISTORY insertMEDICATION_HISTORY(int rep) throws HL7Exception {
        return (CCM_I21_MEDICATION_HISTORY)super.insertRepetition("MEDICATION_HISTORY", rep);
    }

    public CCM_I21_MEDICATION_HISTORY removeMEDICATION_HISTORY(int rep) throws HL7Exception {
        return (CCM_I21_MEDICATION_HISTORY)super.removeRepetition("MEDICATION_HISTORY", rep);
    }

    public CCM_I21_PROBLEM getPROBLEM() {
        return this.getTyped("PROBLEM", CCM_I21_PROBLEM.class);
    }

    public CCM_I21_PROBLEM getPROBLEM(int rep) {
        return this.getTyped("PROBLEM", rep, CCM_I21_PROBLEM.class);
    }

    public int getPROBLEMReps() {
        return this.getReps("PROBLEM");
    }

    public List<CCM_I21_PROBLEM> getPROBLEMAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM", CCM_I21_PROBLEM.class);
    }

    public void insertPROBLEM(CCM_I21_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", structure, rep);
    }

    public CCM_I21_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (CCM_I21_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public CCM_I21_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (CCM_I21_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }

    public CCM_I21_GOAL getGOAL() {
        return this.getTyped("GOAL", CCM_I21_GOAL.class);
    }

    public CCM_I21_GOAL getGOAL(int rep) {
        return this.getTyped("GOAL", rep, CCM_I21_GOAL.class);
    }

    public int getGOALReps() {
        return this.getReps("GOAL");
    }

    public List<CCM_I21_GOAL> getGOALAll() throws HL7Exception {
        return this.getAllAsList("GOAL", CCM_I21_GOAL.class);
    }

    public void insertGOAL(CCM_I21_GOAL structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL", structure, rep);
    }

    public CCM_I21_GOAL insertGOAL(int rep) throws HL7Exception {
        return (CCM_I21_GOAL)super.insertRepetition("GOAL", rep);
    }

    public CCM_I21_GOAL removeGOAL(int rep) throws HL7Exception {
        return (CCM_I21_GOAL)super.removeRepetition("GOAL", rep);
    }

    public CCM_I21_PATHWAY getPATHWAY() {
        return this.getTyped("PATHWAY", CCM_I21_PATHWAY.class);
    }

    public CCM_I21_PATHWAY getPATHWAY(int rep) {
        return this.getTyped("PATHWAY", rep, CCM_I21_PATHWAY.class);
    }

    public int getPATHWAYReps() {
        return this.getReps("PATHWAY");
    }

    public List<CCM_I21_PATHWAY> getPATHWAYAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY", CCM_I21_PATHWAY.class);
    }

    public void insertPATHWAY(CCM_I21_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", structure, rep);
    }

    public CCM_I21_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (CCM_I21_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public CCM_I21_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (CCM_I21_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }

    public REL getREL() {
        return this.getTyped("REL", REL.class);
    }

    public REL getREL(int rep) {
        return this.getTyped("REL", rep, REL.class);
    }

    public int getRELReps() {
        return this.getReps("REL");
    }

    public List<REL> getRELAll() throws HL7Exception {
        return this.getAllAsList("REL", REL.class);
    }

    public void insertREL(REL structure, int rep) throws HL7Exception {
        super.insertRepetition("REL", structure, rep);
    }

    public REL insertREL(int rep) throws HL7Exception {
        return (REL)super.insertRepetition("REL", rep);
    }

    public REL removeREL(int rep) throws HL7Exception {
        return (REL)super.removeRepetition("REL", rep);
    }
}

