/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DT;
import ca.uhn.hl7v2.model.v28.datatype.ST;

public class PLN
extends AbstractComposite {
    private Type[] data;

    public PLN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[4];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new CWE(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new DT(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getIDNumber() {
        return this.getTyped(0, ST.class);
    }

    public ST getPln1_IDNumber() {
        return this.getTyped(0, ST.class);
    }

    public CWE getTypeOfIDNumber() {
        return this.getTyped(1, CWE.class);
    }

    public CWE getPln2_TypeOfIDNumber() {
        return this.getTyped(1, CWE.class);
    }

    public ST getStateOtherQualifyingInformation() {
        return this.getTyped(2, ST.class);
    }

    public ST getPln3_StateOtherQualifyingInformation() {
        return this.getTyped(2, ST.class);
    }

    public DT getExpirationDate() {
        return this.getTyped(3, DT.class);
    }

    public DT getPln4_ExpirationDate() {
        return this.getTyped(3, DT.class);
    }
}

