/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.DTM;
import ca.uhn.hl7v2.model.v27.datatype.NM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class NDS
extends AbstractSegment {
    public NDS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 0, new Object[]{this.getMessage()}, "Notification Reference Number");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Notification Date/Time");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Notification Alert Severity");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Notification Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating NDS - this is probably a bug in the source code generator.", e);
        }
    }

    public NM getNotificationReferenceNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getNds1_NotificationReferenceNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getNotificationDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getNds2_NotificationDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getNotificationAlertSeverity() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getNds3_NotificationAlertSeverity() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getNotificationCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getNds4_NotificationCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new DTM(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

