/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CP;
import ca.uhn.hl7v2.model.v27.datatype.CQ;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.DTM;
import ca.uhn.hl7v2.model.v27.datatype.EI;
import ca.uhn.hl7v2.model.v27.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class AUT
extends AbstractSegment {
    public AUT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorizing Payor, Plan ID");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Authorizing Payor, Company ID");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorizing Payor, Company Name");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorization Effective Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorization Expiration Date");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorization Identifier");
            this.add(CP.class, false, 1, 0, new Object[]{this.getMessage()}, "Reimbursement Limit");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Requested Number of Treatments");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Authorized Number of Treatments");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Process Date");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Requested Discipline(s)");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Authorized Discipline(s)");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating AUT - this is probably a bug in the source code generator.", e);
        }
    }

    public CWE getAuthorizingPayorPlanID() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getAut1_AuthorizingPayorPlanID() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getAuthorizingPayorCompanyID() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getAut2_AuthorizingPayorCompanyID() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getAuthorizingPayorCompanyName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getAut3_AuthorizingPayorCompanyName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getAuthorizationEffectiveDate() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getAut4_AuthorizationEffectiveDate() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getAuthorizationExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getAut5_AuthorizationExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getAuthorizationIdentifier() {
        EI retVal = (EI)this.getTypedField(6, 0);
        return retVal;
    }

    public EI getAut6_AuthorizationIdentifier() {
        EI retVal = (EI)this.getTypedField(6, 0);
        return retVal;
    }

    public CP getReimbursementLimit() {
        CP retVal = (CP)this.getTypedField(7, 0);
        return retVal;
    }

    public CP getAut7_ReimbursementLimit() {
        CP retVal = (CP)this.getTypedField(7, 0);
        return retVal;
    }

    public CQ getRequestedNumberOfTreatments() {
        CQ retVal = (CQ)this.getTypedField(8, 0);
        return retVal;
    }

    public CQ getAut8_RequestedNumberOfTreatments() {
        CQ retVal = (CQ)this.getTypedField(8, 0);
        return retVal;
    }

    public CQ getAuthorizedNumberOfTreatments() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public CQ getAut9_AuthorizedNumberOfTreatments() {
        CQ retVal = (CQ)this.getTypedField(9, 0);
        return retVal;
    }

    public DTM getProcessDate() {
        DTM retVal = (DTM)this.getTypedField(10, 0);
        return retVal;
    }

    public DTM getAut10_ProcessDate() {
        DTM retVal = (DTM)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE[] getRequestedDisciplineS() {
        CWE[] retVal = (CWE[])this.getTypedField(11, new CWE[0]);
        return retVal;
    }

    public CWE[] getAut11_RequestedDisciplineS() {
        CWE[] retVal = (CWE[])this.getTypedField(11, new CWE[0]);
        return retVal;
    }

    public int getRequestedDisciplineSReps() {
        return this.getReps(11);
    }

    public CWE getRequestedDisciplineS(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public CWE getAut11_RequestedDisciplineS(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public int getAut11_RequestedDisciplineSReps() {
        return this.getReps(11);
    }

    public CWE insertRequestedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE insertAut11_RequestedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE removeRequestedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CWE removeAut11_RequestedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CWE[] getAuthorizedDisciplineS() {
        CWE[] retVal = (CWE[])this.getTypedField(12, new CWE[0]);
        return retVal;
    }

    public CWE[] getAut12_AuthorizedDisciplineS() {
        CWE[] retVal = (CWE[])this.getTypedField(12, new CWE[0]);
        return retVal;
    }

    public int getAuthorizedDisciplineSReps() {
        return this.getReps(12);
    }

    public CWE getAuthorizedDisciplineS(int rep) {
        CWE retVal = (CWE)this.getTypedField(12, rep);
        return retVal;
    }

    public CWE getAut12_AuthorizedDisciplineS(int rep) {
        CWE retVal = (CWE)this.getTypedField(12, rep);
        return retVal;
    }

    public int getAut12_AuthorizedDisciplineSReps() {
        return this.getReps(12);
    }

    public CWE insertAuthorizedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(12, rep);
    }

    public CWE insertAut12_AuthorizedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(12, rep);
    }

    public CWE removeAuthorizedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(12, rep);
    }

    public CWE removeAut12_AuthorizedDisciplineS(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(12, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new DTM(this.getMessage());
            }
            case 5: {
                return new EI(this.getMessage());
            }
            case 6: {
                return new CP(this.getMessage());
            }
            case 7: {
                return new CQ(this.getMessage());
            }
            case 8: {
                return new CQ(this.getMessage());
            }
            case 9: {
                return new DTM(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

