/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v27.group.OUL_R22_CONTAINER;
import ca.uhn.hl7v2.model.v27.group.OUL_R22_ORDER;
import ca.uhn.hl7v2.model.v27.group.OUL_R22_SPECIMEN_OBSERVATION;
import ca.uhn.hl7v2.model.v27.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OUL_R22_SPECIMEN
extends AbstractGroup {
    public OUL_R22_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(OUL_R22_SPECIMEN_OBSERVATION.class, false, true, false);
            this.add(OUL_R22_CONTAINER.class, false, true, false);
            this.add(OUL_R22_ORDER.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OUL_R22_SPECIMEN - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public SPM getSPM() {
        SPM retVal = this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public OUL_R22_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION() {
        OUL_R22_SPECIMEN_OBSERVATION retVal = this.getTyped("SPECIMEN_OBSERVATION", OUL_R22_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public OUL_R22_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION(int rep) {
        OUL_R22_SPECIMEN_OBSERVATION retVal = this.getTyped("SPECIMEN_OBSERVATION", rep, OUL_R22_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public int getSPECIMEN_OBSERVATIONReps() {
        return this.getReps("SPECIMEN_OBSERVATION");
    }

    public List<OUL_R22_SPECIMEN_OBSERVATION> getSPECIMEN_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_OBSERVATION", OUL_R22_SPECIMEN_OBSERVATION.class);
    }

    public void insertSPECIMEN_OBSERVATION(OUL_R22_SPECIMEN_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_OBSERVATION", structure, rep);
    }

    public OUL_R22_SPECIMEN_OBSERVATION insertSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OUL_R22_SPECIMEN_OBSERVATION)super.insertRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OUL_R22_SPECIMEN_OBSERVATION removeSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OUL_R22_SPECIMEN_OBSERVATION)super.removeRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OUL_R22_CONTAINER getCONTAINER() {
        OUL_R22_CONTAINER retVal = this.getTyped("CONTAINER", OUL_R22_CONTAINER.class);
        return retVal;
    }

    public OUL_R22_CONTAINER getCONTAINER(int rep) {
        OUL_R22_CONTAINER retVal = this.getTyped("CONTAINER", rep, OUL_R22_CONTAINER.class);
        return retVal;
    }

    public int getCONTAINERReps() {
        return this.getReps("CONTAINER");
    }

    public List<OUL_R22_CONTAINER> getCONTAINERAll() throws HL7Exception {
        return this.getAllAsList("CONTAINER", OUL_R22_CONTAINER.class);
    }

    public void insertCONTAINER(OUL_R22_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition("CONTAINER", structure, rep);
    }

    public OUL_R22_CONTAINER insertCONTAINER(int rep) throws HL7Exception {
        return (OUL_R22_CONTAINER)super.insertRepetition("CONTAINER", rep);
    }

    public OUL_R22_CONTAINER removeCONTAINER(int rep) throws HL7Exception {
        return (OUL_R22_CONTAINER)super.removeRepetition("CONTAINER", rep);
    }

    public OUL_R22_ORDER getORDER() {
        OUL_R22_ORDER retVal = this.getTyped("ORDER", OUL_R22_ORDER.class);
        return retVal;
    }

    public OUL_R22_ORDER getORDER(int rep) {
        OUL_R22_ORDER retVal = this.getTyped("ORDER", rep, OUL_R22_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<OUL_R22_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", OUL_R22_ORDER.class);
    }

    public void insertORDER(OUL_R22_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public OUL_R22_ORDER insertORDER(int rep) throws HL7Exception {
        return (OUL_R22_ORDER)super.insertRepetition("ORDER", rep);
    }

    public OUL_R22_ORDER removeORDER(int rep) throws HL7Exception {
        return (OUL_R22_ORDER)super.removeRepetition("ORDER", rep);
    }
}

