/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v27.group.CCR_I16_ROLE_PATHWAY;
import ca.uhn.hl7v2.model.v27.segment.OBX;
import ca.uhn.hl7v2.model.v27.segment.PTH;
import ca.uhn.hl7v2.model.v27.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCR_I16_PATHWAY
extends AbstractGroup {
    public CCR_I16_PATHWAY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PTH.class, true, false, false);
            this.add(VAR.class, false, true, false);
            this.add(CCR_I16_ROLE_PATHWAY.class, false, true, false);
            this.add(OBX.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCR_I16_PATHWAY - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public PTH getPTH() {
        PTH retVal = this.getTyped("PTH", PTH.class);
        return retVal;
    }

    public VAR getVAR() {
        VAR retVal = this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public CCR_I16_ROLE_PATHWAY getROLE_PATHWAY() {
        CCR_I16_ROLE_PATHWAY retVal = this.getTyped("ROLE_PATHWAY", CCR_I16_ROLE_PATHWAY.class);
        return retVal;
    }

    public CCR_I16_ROLE_PATHWAY getROLE_PATHWAY(int rep) {
        CCR_I16_ROLE_PATHWAY retVal = this.getTyped("ROLE_PATHWAY", rep, CCR_I16_ROLE_PATHWAY.class);
        return retVal;
    }

    public int getROLE_PATHWAYReps() {
        return this.getReps("ROLE_PATHWAY");
    }

    public List<CCR_I16_ROLE_PATHWAY> getROLE_PATHWAYAll() throws HL7Exception {
        return this.getAllAsList("ROLE_PATHWAY", CCR_I16_ROLE_PATHWAY.class);
    }

    public void insertROLE_PATHWAY(CCR_I16_ROLE_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("ROLE_PATHWAY", structure, rep);
    }

    public CCR_I16_ROLE_PATHWAY insertROLE_PATHWAY(int rep) throws HL7Exception {
        return (CCR_I16_ROLE_PATHWAY)super.insertRepetition("ROLE_PATHWAY", rep);
    }

    public CCR_I16_ROLE_PATHWAY removeROLE_PATHWAY(int rep) throws HL7Exception {
        return (CCR_I16_ROLE_PATHWAY)super.removeRepetition("ROLE_PATHWAY", rep);
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }
}

