/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RF1
extends AbstractSegment {
    public RF1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Referral Status");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Referral Priority");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Referral Type");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage()}, "Referral Disposition");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Referral Category");
            this.add(EI.class, true, 1, 30, new Object[]{this.getMessage()}, "Originating Referral Identifier");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Effective Date");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Expiration Date");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Process Date");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage()}, "Referral Reason");
            this.add(EI.class, false, 0, 30, new Object[]{this.getMessage()}, "External Referral Identifier");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Referral Documentation Completion Status");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RF1 - this is probably a bug in the source code generator.", e);
        }
    }

    public CWE getReferralStatus() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getRf11_ReferralStatus() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getReferralPriority() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getRf12_ReferralPriority() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getReferralType() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getRf13_ReferralType() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE[] getReferralDisposition() {
        CWE[] retVal = (CWE[])this.getTypedField(4, new CWE[0]);
        return retVal;
    }

    public CWE[] getRf14_ReferralDisposition() {
        CWE[] retVal = (CWE[])this.getTypedField(4, new CWE[0]);
        return retVal;
    }

    public int getReferralDispositionReps() {
        return this.getReps(4);
    }

    public CWE getReferralDisposition(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public CWE getRf14_ReferralDisposition(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getRf14_ReferralDispositionReps() {
        return this.getReps(4);
    }

    public CWE insertReferralDisposition(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE insertRf14_ReferralDisposition(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE removeReferralDisposition(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE removeRf14_ReferralDisposition(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE getReferralCategory() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getRf15_ReferralCategory() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getOriginatingReferralIdentifier() {
        EI retVal = (EI)this.getTypedField(6, 0);
        return retVal;
    }

    public EI getRf16_OriginatingReferralIdentifier() {
        EI retVal = (EI)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getEffectiveDate() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getRf17_EffectiveDate() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getRf18_ExpirationDate() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getProcessDate() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public DTM getRf19_ProcessDate() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE[] getReferralReason() {
        CWE[] retVal = (CWE[])this.getTypedField(10, new CWE[0]);
        return retVal;
    }

    public CWE[] getRf110_ReferralReason() {
        CWE[] retVal = (CWE[])this.getTypedField(10, new CWE[0]);
        return retVal;
    }

    public int getReferralReasonReps() {
        return this.getReps(10);
    }

    public CWE getReferralReason(int rep) {
        CWE retVal = (CWE)this.getTypedField(10, rep);
        return retVal;
    }

    public CWE getRf110_ReferralReason(int rep) {
        CWE retVal = (CWE)this.getTypedField(10, rep);
        return retVal;
    }

    public int getRf110_ReferralReasonReps() {
        return this.getReps(10);
    }

    public CWE insertReferralReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(10, rep);
    }

    public CWE insertRf110_ReferralReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(10, rep);
    }

    public CWE removeReferralReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(10, rep);
    }

    public CWE removeRf110_ReferralReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(10, rep);
    }

    public EI[] getExternalReferralIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(11, new EI[0]);
        return retVal;
    }

    public EI[] getRf111_ExternalReferralIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(11, new EI[0]);
        return retVal;
    }

    public int getExternalReferralIdentifierReps() {
        return this.getReps(11);
    }

    public EI getExternalReferralIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(11, rep);
        return retVal;
    }

    public EI getRf111_ExternalReferralIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(11, rep);
        return retVal;
    }

    public int getRf111_ExternalReferralIdentifierReps() {
        return this.getReps(11);
    }

    public EI insertExternalReferralIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(11, rep);
    }

    public EI insertRf111_ExternalReferralIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(11, rep);
    }

    public EI removeExternalReferralIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(11, rep);
    }

    public EI removeRf111_ExternalReferralIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(11, rep);
    }

    public CWE getReferralDocumentationCompletionStatus() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getRf112_ReferralDocumentationCompletionStatus() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new EI(this.getMessage());
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new DTM(this.getMessage());
            }
            case 8: {
                return new DTM(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new EI(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

