/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v251.group.RSP_Q11_QUERY_RESULT_CLUSTER;
import ca.uhn.hl7v2.model.v251.segment.DSC;
import ca.uhn.hl7v2.model.v251.segment.ERR;
import ca.uhn.hl7v2.model.v251.segment.MSA;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.QAK;
import ca.uhn.hl7v2.model.v251.segment.QPD;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RSP_Q11
extends AbstractMessage {
    public RSP_Q11() {
        this(new DefaultModelClassFactory());
    }

    public RSP_Q11(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(QAK.class, true, false);
            this.add(QPD.class, true, false);
            this.add(RSP_Q11_QUERY_RESULT_CLUSTER.class, false, false);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RSP_Q11 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public QAK getQAK() {
        return this.getTyped("QAK", QAK.class);
    }

    public QPD getQPD() {
        return this.getTyped("QPD", QPD.class);
    }

    public RSP_Q11_QUERY_RESULT_CLUSTER getQUERY_RESULT_CLUSTER() {
        return this.getTyped("QUERY_RESULT_CLUSTER", RSP_Q11_QUERY_RESULT_CLUSTER.class);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

