/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.segment.CSP;
import ca.uhn.hl7v2.model.v251.segment.CSR;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.model.v251.segment.PV1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CRM_C01_PATIENT
extends AbstractGroup {
    public CRM_C01_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PV1.class, false, false, false);
            this.add(CSR.class, true, false, false);
            this.add(CSP.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CRM_C01_PATIENT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public PV1 getPV1() {
        PV1 retVal = this.getTyped("PV1", PV1.class);
        return retVal;
    }

    public CSR getCSR() {
        CSR retVal = this.getTyped("CSR", CSR.class);
        return retVal;
    }

    public CSP getCSP() {
        CSP retVal = this.getTyped("CSP", CSP.class);
        return retVal;
    }

    public CSP getCSP(int rep) {
        CSP retVal = this.getTyped("CSP", rep, CSP.class);
        return retVal;
    }

    public int getCSPReps() {
        return this.getReps("CSP");
    }

    public List<CSP> getCSPAll() throws HL7Exception {
        return this.getAllAsList("CSP", CSP.class);
    }

    public void insertCSP(CSP structure, int rep) throws HL7Exception {
        super.insertRepetition("CSP", structure, rep);
    }

    public CSP insertCSP(int rep) throws HL7Exception {
        return (CSP)super.insertRepetition("CSP", rep);
    }

    public CSP removeCSP(int rep) throws HL7Exception {
        return (CSP)super.removeRepetition("CSP", rep);
    }
}

