/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.DR;
import ca.uhn.hl7v2.model.v24.datatype.SI;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.XAD;
import ca.uhn.hl7v2.model.v24.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class AFF
extends AbstractSegment {
    public AFF(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 60, new Object[]{this.getMessage()}, "Set ID - AFF");
            this.add(XON.class, true, 1, 250, new Object[]{this.getMessage()}, "Professional Organization");
            this.add(XAD.class, false, 1, 250, new Object[]{this.getMessage()}, "Professional Organization Address");
            this.add(DR.class, false, 0, 52, new Object[]{this.getMessage()}, "Professional Organization Affiliation Date Range");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Professional Affiliation Additional Information");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating AFF - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDAFF() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getAff1_SetIDAFF() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public XON getProfessionalOrganization() {
        XON retVal = (XON)this.getTypedField(2, 0);
        return retVal;
    }

    public XON getAff2_ProfessionalOrganization() {
        XON retVal = (XON)this.getTypedField(2, 0);
        return retVal;
    }

    public XAD getProfessionalOrganizationAddress() {
        XAD retVal = (XAD)this.getTypedField(3, 0);
        return retVal;
    }

    public XAD getAff3_ProfessionalOrganizationAddress() {
        XAD retVal = (XAD)this.getTypedField(3, 0);
        return retVal;
    }

    public DR[] getProfessionalOrganizationAffiliationDateRange() {
        DR[] retVal = (DR[])this.getTypedField(4, new DR[0]);
        return retVal;
    }

    public DR[] getAff4_ProfessionalOrganizationAffiliationDateRange() {
        DR[] retVal = (DR[])this.getTypedField(4, new DR[0]);
        return retVal;
    }

    public int getProfessionalOrganizationAffiliationDateRangeReps() {
        return this.getReps(4);
    }

    public DR getProfessionalOrganizationAffiliationDateRange(int rep) {
        DR retVal = (DR)this.getTypedField(4, rep);
        return retVal;
    }

    public DR getAff4_ProfessionalOrganizationAffiliationDateRange(int rep) {
        DR retVal = (DR)this.getTypedField(4, rep);
        return retVal;
    }

    public int getAff4_ProfessionalOrganizationAffiliationDateRangeReps() {
        return this.getReps(4);
    }

    public DR insertProfessionalOrganizationAffiliationDateRange(int rep) throws HL7Exception {
        return (DR)super.insertRepetition(4, rep);
    }

    public DR insertAff4_ProfessionalOrganizationAffiliationDateRange(int rep) throws HL7Exception {
        return (DR)super.insertRepetition(4, rep);
    }

    public DR removeProfessionalOrganizationAffiliationDateRange(int rep) throws HL7Exception {
        return (DR)super.removeRepetition(4, rep);
    }

    public DR removeAff4_ProfessionalOrganizationAffiliationDateRange(int rep) throws HL7Exception {
        return (DR)super.removeRepetition(4, rep);
    }

    public ST getProfessionalAffiliationAdditionalInformation() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getAff5_ProfessionalAffiliationAdditionalInformation() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new XON(this.getMessage());
            }
            case 2: {
                return new XAD(this.getMessage());
            }
            case 3: {
                return new DR(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

