/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.OML_O21_ORDER_GENERAL;
import ca.uhn.hl7v2.model.v24.group.OML_O21_PATIENT;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OML_O21
extends AbstractMessage {
    public OML_O21() {
        this(new DefaultModelClassFactory());
    }

    public OML_O21(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(OML_O21_PATIENT.class, false, false);
            this.add(OML_O21_ORDER_GENERAL.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OML_O21 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OML_O21_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", OML_O21_PATIENT.class);
    }

    public OML_O21_ORDER_GENERAL getORDER_GENERAL() {
        return this.getTyped("ORDER_GENERAL", OML_O21_ORDER_GENERAL.class);
    }

    public OML_O21_ORDER_GENERAL getORDER_GENERAL(int rep) {
        return this.getTyped("ORDER_GENERAL", rep, OML_O21_ORDER_GENERAL.class);
    }

    public int getORDER_GENERALReps() {
        return this.getReps("ORDER_GENERAL");
    }

    public List<OML_O21_ORDER_GENERAL> getORDER_GENERALAll() throws HL7Exception {
        return this.getAllAsList("ORDER_GENERAL", OML_O21_ORDER_GENERAL.class);
    }

    public void insertORDER_GENERAL(OML_O21_ORDER_GENERAL structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER_GENERAL", structure, rep);
    }

    public OML_O21_ORDER_GENERAL insertORDER_GENERAL(int rep) throws HL7Exception {
        return (OML_O21_ORDER_GENERAL)super.insertRepetition("ORDER_GENERAL", rep);
    }

    public OML_O21_ORDER_GENERAL removeORDER_GENERAL(int rep) throws HL7Exception {
        return (OML_O21_ORDER_GENERAL)super.removeRepetition("ORDER_GENERAL", rep);
    }
}

