/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.segment.EVN;
import ca.uhn.hl7v2.model.v23.segment.OBX;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.model.v23.segment.PV1;
import ca.uhn.hl7v2.model.v23.segment.TXA;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class DOC_T12_RESULT
extends AbstractGroup {
    public DOC_T12_RESULT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EVN.class, false, false, false);
            this.add(PID.class, true, false, false);
            this.add(PV1.class, true, false, false);
            this.add(TXA.class, true, false, false);
            this.add(OBX.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DOC_T12_RESULT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public EVN getEVN() {
        EVN retVal = this.getTyped("EVN", EVN.class);
        return retVal;
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public PV1 getPV1() {
        PV1 retVal = this.getTyped("PV1", PV1.class);
        return retVal;
    }

    public TXA getTXA() {
        TXA retVal = this.getTyped("TXA", TXA.class);
        return retVal;
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }
}

