/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import ca.infodata.util1.date.LocaleProvider;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Messages {
    private static final Logger logger = Logger.getLogger(Messages.class.getName());
    private static final String BUNDLE_NAME = "ca.infodata.util1.messages";
    public static final ResourceBundle EN = ResourceBundle.getBundle("ca.infodata.util1.messages", Locale.ENGLISH);
    public static final ResourceBundle FR = ResourceBundle.getBundle("ca.infodata.util1.messages", Locale.FRENCH);

    private Messages() {
        throw new UnsupportedOperationException();
    }

    public static String getString2(String key, ResourceBundle bundle) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getString(String key, String ... vars) {
        try {
            String text = Messages.getResourceBundle().getString(key);
            if (vars != null && vars.length > 0) {
                text = MessageFormat.format(text, vars);
            }
            return text;
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    private static ResourceBundle getResourceBundle() {
        if (LocaleProvider.isFrench()) {
            return FR;
        }
        if (LocaleProvider.isEnglish()) {
            return EN;
        }
        logger.log(Level.WARNING, "No ressource bundle for locale " + LocaleProvider.getLocale() + ". Use default FR");
        return FR;
    }
}

