/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7.tools;

import ca.infodata.readhl7.tools.LocaleSource;
import java.util.Locale;

public class PerThreadLocaleStrategy
implements LocaleSource {
    private ThreadLocal<Locale> locale;
    private final Locale _default;

    public PerThreadLocaleStrategy() {
        this(Locale.getDefault());
    }

    public PerThreadLocaleStrategy(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale is null");
        }
        this._default = locale;
        this.locale = new ThreadLocal<Locale>(){

            @Override
            protected Locale initialValue() {
                return PerThreadLocaleStrategy.this._default;
            }
        };
    }

    @Override
    public Locale get() {
        return this.locale.get();
    }

    @Override
    public void set(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException();
        }
        this.locale.set(locale);
    }

    @Override
    public void reset() {
        this.locale.remove();
    }
}

