/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.singleview;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PatientImageAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.IDDataObject;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.chat.LINK_TYPE;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDocumentType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDocuments;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.data.middle.dataobjects.pdf.PdfUtil;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnal;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.browser.HtmlImageViewerResource;
import ca.infodata.ofys.ui.browser.HtmlPdfViewerResource;
import ca.infodata.ofys.ui.browser.HtmlResource;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.ICancelablePart;
import ca.infodata.ofys.ui.controls.IPrintable;
import ca.infodata.ofys.ui.controls.ISaveablePart;
import ca.infodata.ofys.ui.controls.report2.PrintDialog2;
import ca.infodata.ofys.ui.controls.windows.AskTextQuestionDialog;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.scan.scan.ScanEditor;
import ca.infodata.ofys.ui.scan.singleview.BaseScanSingleViewEditor;
import ca.infodata.ofys.ui.scan.singleview.BaseScanSingleViewSection;
import ca.infodata.ofys.ui.scan.singleview.IScanSingleViewEditorSection;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.FastDateFormat;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class ScanSingleViewEditor
extends BaseScanSingleViewEditor
implements IPrintable,
ICancelablePart,
ISaveablePart,
IPatientRelated {
    private static final Logger logger = Logger.getLogger(ScanSingleViewEditor.class.getName());
    private static final String DOCUMENT = Messages.getString((String)"ScanSingleViewEditor.DOCUMENT", (String[])new String[0]);
    private static final String MESSAGE_NULL_DOC = Messages.getString((String)"MESSAGE_NULL_DOC", (String[])new String[0]);
    private static final String ASSOCIER_DOCUMENT = Messages.getString((String)"ASSOCIER_DOCUMENT", (String[])new String[0]);
    private static final String VEUILLER_ENTRER_DESCR = Messages.getString((String)"VEUILLER_ENTRER_DESCR", (String[])new String[0]);
    private static final String DESCR_NE_PEUT_ETRE_NULL = Messages.getString((String)"DESCR_NE_PEUT_ETRE_NULL", (String[])new String[0]);
    protected String localDocumentFileName = null;
    protected boolean addPrintedByText = false;

    @Override
    protected void onImageRotated() {
    }

    public void print() {
        IDataObject dataObj = this.getDataObject();
        XBasePatientImage clonedObj = null;
        if (dataObj instanceof XBasePatientImage) {
            clonedObj = ((XBasePatientImage)dataObj).clone();
            clonedObj.patient = null;
        } else {
            XPatientImage dataObject = this.getPatientImage();
            clonedObj = dataObject.toXBase(false);
        }
        PrintDialog2 dialog = new PrintDialog2(this.getSite().getShell(), (Serializable)clonedObj, null, this.localDocumentFileName);
        UI.centerComposite((Composite)dialog.getShell(), (Composite)this.getEditorSite().getShell());
        dialog.open();
    }

    public void setToolBarStatus() {
    }

    public void showDataObject() {
        XPatientImage patientImage = this.getPatientImage();
        for (IScanSingleViewEditorSection section : this.sections) {
            section.setPatientImage(patientImage);
            section.showDataObject();
        }
        if (patientImage == null) {
            this.showPicture(null);
        } else {
            this.showPicture(patientImage.getPicture());
        }
    }

    private void showPicture(byte[] picture) {
        try {
            if (picture != null && picture.length > 3) {
                String hId = "i" + System.currentTimeMillis();
                String printedBy = "\"" + Messages.getString((String)"PRINTED_BY", (String[])new String[0]) + " " + Application.get().getGlobalInstances().getSession().getUser().getPersonNameOrTextOrEmpty() + " " + FastDateFormat.getInstance((String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm")).format(new Date()) + " - " + Messages.getString((String)"CONFIDENTIAL", (String[])new String[0]) + "\"";
                if (ScanEditor.isPdf(picture)) {
                    if (this.addPrintedByText) {
                        picture = PdfUtil.addPrintedByToPdf((byte[])picture, (String)printedBy);
                    }
                    String pdfFileName = "p" + hId + ".pdf";
                    boolean recentViewer = (Boolean)Application.get().getPreferencesPluginController().getUserProp("user_settings_UseNewPDFViewer");
                    if (LibPlugin.ON_WIN) {
                        recentViewer = false;
                    }
                    HtmlPdfViewerResource htmlResource = HtmlBrowserTools.newHtmlPdfViewerResource((String)pdfFileName, null, (byte[])picture, (boolean)this.getAllowPrintingFromPdfViewer(), (boolean)recentViewer);
                    this.browser.setHtml((HtmlResource)htmlResource);
                } else {
                    if (this.addPrintedByText) {
                        Display display = Display.getDefault();
                        Image image1 = new Image((Device)display, (InputStream)new ByteArrayInputStream(picture));
                        Image image2 = new Image((Device)display, image1.getBounds());
                        GC gc = new GC((Drawable)image2);
                        gc.drawImage(image1, 0, 0);
                        gc.setBackground(display.getSystemColor(1));
                        gc.setForeground(display.getSystemColor(2));
                        gc.setFont(ResourceGetter.getFontNormal());
                        Point textExtent = gc.textExtent(printedBy, 0x40000000);
                        gc.drawText(printedBy, image2.getBounds().width / 2 - textExtent.x / 2, image2.getBounds().height - 40);
                        gc.dispose();
                        ByteArrayOutputStream os = new ByteArrayOutputStream(picture.length + 5000);
                        ImageLoader imageLoader = new ImageLoader();
                        imageLoader.data = new ImageData[]{image2.getImageData()};
                        imageLoader.save((OutputStream)os, 4);
                        image1.dispose();
                        image2.dispose();
                        picture = os.toByteArray();
                    }
                    String imgSignedName = "pdf/s" + hId + ".jpg";
                    HtmlImageViewerResource htmlResource = HtmlBrowserTools.newHtmlImageViewerResource((String)imgSignedName, null, (byte[])picture);
                    this.browser.setHtml((HtmlResource)htmlResource);
                }
            } else {
                this.browser.setHtml("<html><body><h1>Document absent... </h1></body></html>");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to show already saved picture on patientImage.id " + (this.getPatientImage() == null ? null : this.getPatientImage().getId()), e);
            this.browser.setHtml(HtmlBrowserTools.newErrorTemplateResource((Exception)e, null));
        }
    }

    protected boolean getAllowPrintingFromPdfViewer() {
        return true;
    }

    public String getEditorTitle() {
        XPatientImage patientImage = this.getPatientImage();
        if (patientImage != null) {
            String date = LocalDateFormat.nullSafeFormat((LocalDate)patientImage.getDocumentDate(), (String)FormatDateProvider.getFormatDate().toString());
            String patient = patientImage.getPatient().getNameBirthdateSex();
            String name = patientImage.getName();
            if (Application.get().getGlobalInstances().inDebugMode()) {
                XPatientImageProfessionnal pip = BaseScanSingleViewSection.getSessionProfessionnalPatientImageProfessionnal(this.getPatientImage());
                JoinList list = new JoinList(" ");
                list.setAllowBlank(true);
                list.add(pip.getId().intValue()).add((CharSequence)date).add((CharSequence)patient).add((CharSequence)":").add((CharSequence)name);
                return list.toString();
            }
            return String.valueOf(date) + " " + patient + " : " + name;
        }
        IDataObject dataObject = this.getDataObject();
        if (dataObject instanceof XBasePatientImage) {
            XBasePatientImage xBasePatientImage = (XBasePatientImage)dataObject;
            return xBasePatientImage.str;
        }
        return DOCUMENT;
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/print-icon32.png");
    }

    public void initDataOverride() {
        IDataObject dataObject = ((EditorInput)this.getEditorInput()).getDataObject();
        if (dataObject instanceof XBasePatientImage) {
            this.loadFromId(dataObject);
        } else if (dataObject instanceof IDDataObject) {
            IDDataObject id = (IDDataObject)dataObject;
            if (XBasePatientImage.class.equals((Object)id.getReferingClass()) || id.getReferingClass().equals(XPatientImage.class)) {
                this.loadFromId(dataObject);
            }
        } else if (dataObject instanceof XPatientImage) {
            this.loadFromId(dataObject);
        }
    }

    protected void loadFromId(IDataObject dataObject, ICallback callback) {
        try {
            PatientImageAccessorClient.getInstance().getPatientImageAndSetSeenStatus(this.getUniqueKey(), Application.get().getGlobalInstances().getSession(), callback, dataObject.getId().intValue());
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
            callback.kill();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to load PatientImage for " + dataObject, e);
            callback.kill();
        }
    }

    protected void loadFromId(IDataObject dataObject) {
        JobCallback callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

            public void responseReceived(final ReturnObject response) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        XPatientImage object = (XPatientImage)response.getObj();
                        if (object != null && !ScanSingleViewEditor.this.isDisposed()) {
                            ScanSingleViewEditor.this.initializeCompleteDataObject((EditableDataObject)object);
                        }
                    }
                });
            }
        };
        this.loadFromId(dataObject, (ICallback)callback);
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return PatientImageAccessorClient.getInstance();
    }

    public boolean isDataDirty() {
        return this.getPatientImage() != null && this.getPatientImage().isDirty();
    }

    @Override
    protected XPatientImage getPatientImage() {
        IEditorInput input = this.getEditorInput();
        return (XPatientImage)(input == null ? null : ((EditorInput)input).getCompleteDataObject());
    }

    protected IDataObject getDataObject() {
        IEditorInput input = this.getEditorInput();
        return input == null ? null : ((EditorInput)input).getDataObject();
    }

    public IPatient getPatient() {
        if (this.getPatientImage() != null) {
            return this.getPatientImage().getPatient();
        }
        return null;
    }

    public MessageLink getMessageLink() {
        MessageLink ml = null;
        if (this.getPatientImage() != null && this.getPatientImage().getId() != null) {
            ml = new MessageLink(this.getPatient(), LINK_TYPE.SCAN, this.getPatientImage().getId());
        }
        return ml;
    }

    public void initializeCompleteDataObject(EditableDataObject completeDataObject) {
        XPatientImage image = (XPatientImage)completeDataObject;
        if (image != null) {
            PersonUiPlugin.getDefault().setCurrentPatient(image.getPatient());
        }
        for (IScanSingleViewEditorSection section : this.sections) {
            section.setPatientImage(image);
        }
        super.initializeCompleteDataObject(completeDataObject);
    }

    public void saved() {
        super.saved();
        XPatientImage patientImage = this.getPatientImage();
        for (IScanSingleViewEditorSection section : this.sections) {
            section.setPatientImage(patientImage);
        }
    }

    public XDocuments getDocuments(Integer idPatientAnchor) {
        final XPatientImage xpi = this.getPatientImage();
        if (xpi != null && xpi.getId() != null && xpi.getPatient() != null && xpi.getPatient().getId().equals(idPatientAnchor)) {
            final XDocuments doc = new XDocuments();
            final Boolean[] firstTryAndCanceled = new Boolean[]{true, false};
            while (!(doc.getDescription() != null && doc.getDescription().trim().length() != 0 || firstTryAndCanceled[1].booleanValue())) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AskTextQuestionDialog diag = null;
                        if (firstTryAndCanceled[0].booleanValue()) {
                            diag = new AskTextQuestionDialog(ScanSingleViewEditor.this.getShell(), xpi.getName(), ASSOCIER_DOCUMENT, new String[]{VEUILLER_ENTRER_DESCR});
                            firstTryAndCanceled[0] = false;
                        } else {
                            diag = new AskTextQuestionDialog(ScanSingleViewEditor.this.getShell(), xpi.getName(), ASSOCIER_DOCUMENT, new String[]{VEUILLER_ENTRER_DESCR, DESCR_NE_PEUT_ETRE_NULL});
                        }
                        diag.open();
                        if (diag.getButtonClicked() == 0) {
                            doc.setDescription(diag.getAnswer());
                        } else {
                            firstTryAndCanceled[1] = true;
                        }
                    }
                });
            }
            if (!firstTryAndCanceled[1].booleanValue()) {
                doc.setIdDocument(xpi.getId());
                doc.setType(XDocumentType.SCAN);
                doc.setIsDeleted(Boolean.FALSE);
                return doc;
            }
        }
        return null;
    }

    public Shell getShell() {
        return this.getSite().getShell();
    }

    public String getMsgOnNullDocuments() {
        return MESSAGE_NULL_DOC;
    }

    public boolean isPrintAllowed() {
        XPatientImage image = this.getPatientImage();
        return image != null && image.getId() != null;
    }
}

