/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.dsq;

import ca.infodata.dsq.domain.labo.getlist.LaboReportHeader;
import ca.infodata.dsq.domain.labo.getreport.pdf.LaboReportHeaderFlat;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.scan.menu.PatientImageElements;
import ca.infodata.ofys.ui.scan.singleview.LaboAndScanSingleViewEditor;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public class LaboReportHeaderImageElement
extends PatientImageElements {
    private LaboReportHeaderFlat labo;
    private IPatient patient;

    public LaboReportHeaderImageElement(ITreeElements parent, IPatient iPatient, LaboReportHeaderFlat laboReportHeaderFlat) {
        super(parent);
        this.patient = iPatient;
        this.labo = laboReportHeaderFlat;
        this.setShowPatientName(false);
        this.setPatientImageInfo(LaboReportHeaderImageElement.getPatientImage(this.patient, this.labo));
    }

    public static XBasePatientImage getPatientImage(IPatient patient, LaboReportHeaderFlat labo) {
        XBasePatientImage image = new XBasePatientImage();
        image.setIdPatient(patient.getId());
        image.setResult(labo.laboReportHeader.anormalFlag ? XPatientImageResultType.ANORMAL : XPatientImageResultType.SO);
        image.setId(null);
        image.setDecorators(XImageDecorator.NULL_DECORATORS);
        image.setDocumentDate(LocalDate.fromTimeInMillisUTC((Long)labo.laboReportHeader.specimenCollectionStartDatetime));
        image.valDsq = labo;
        image.setStr(LaboReportHeaderImageElement.formatDsqPatientImage(patient, labo));
        image.setStrWithoutPatient(LaboReportHeaderImageElement.formatDsqPatientImage(null, labo));
        return image;
    }

    public static String formatDsqPatientImage(IPatient patient, LaboReportHeaderFlat e) {
        JoinList joinList = new JoinList(", ");
        joinList.setAllowBlank(false);
        joinList.setTrim(true);
        String date = DateUtil.format((Long)e.laboReportHeader.specimenCollectionStartDatetime, (String)"yyyy-MM-dd HH:mm:ss");
        if (e.laboReportHeader.title != null) {
            List keywords = LaboReportHeader.getKeywords((String)e.laboReportHeader.title);
            joinList.add((CharSequence)new JoinList("; ", (Collection)keywords).toString());
        }
        if (e.laboReportHeader.reportType != null && "SURGP".equals(e.laboReportHeader.reportType.code)) {
            joinList.add((CharSequence)"s/o");
        }
        if ("completed".equals(e.laboResultStatus.code)) {
            joinList.add((CharSequence)"Final");
        } else if ("active".equals(e.laboResultStatus.code)) {
            joinList.add((CharSequence)"Partiel");
        } else {
            joinList.add((CharSequence)"s/o");
        }
        joinList.add((CharSequence)StringUtils.defaultString((String)e.laboReportHeader.reportType.text));
        if (e.laboRequest.author != null) {
            joinList.add((CharSequence)StringUtils.join((String)", ", (Object[])new Object[]{e.laboRequest.author.getFirstName(), e.laboRequest.author.getLastName()}));
        }
        joinList.add((CharSequence)(e.laboReportHeader.anormalFlag ? "anormal" : "non d\u00e9fini"));
        String text = "";
        if (patient != null) {
            String ptnom = " (" + patient.getName() + ")";
            text = String.valueOf(date) + " : " + ptnom + " " + joinList.toString();
        } else {
            text = String.valueOf(date) + " : " + joinList.toString();
        }
        if (Application.get().getGlobalInstances().inDebugMode()) {
            text = String.valueOf(StringUtils.defaultString((String)e.laboResultId.extension)) + ", " + text;
        }
        return text;
    }

    @Override
    public void doKeyListener(Control control, KeyEvent ke) {
        super.doKeyListener(control, ke);
    }

    @Override
    public void doDoubleClick() {
        super.doDoubleClick();
    }

    @Override
    public void doSelect() {
        super.doSelect();
    }

    @Override
    public String getEditorClass() {
        return LaboAndScanSingleViewEditor.class.getName();
    }

    @Override
    public IEditorInput getEditorInput() {
        return super.getEditorInput();
    }
}

