/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.file.FileUtil;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ScanTextToPdfDialog {
    private static final Logger logger = Logger.getLogger(ScanTextToPdfDialog.class.getName());
    private static final String OKI = Messages.getString((String)"ScanTextToPdfDialog.OKI", (String[])new String[0]);
    private static final String ANNULER = Messages.getString((String)"ScanTextToPdfDialog.ANNULER", (String[])new String[0]);
    private static final String TITLE_DIALOG = Messages.getString((String)"ScanTextToPdfDialog.TITLE_DIALOG", (String[])new String[0]);
    private static final String TITLE = Messages.getString((String)"ScanTextToPdfDialog.TITLE", (String[])new String[0]);
    private static final String TEXT = Messages.getString((String)"ScanTextToPdfDialog.TEXT", (String[])new String[0]);
    private static final String PROB_TITLE = Messages.getString((String)"ScanTextToPdfDialog.PROB_TITLE", (String[])new String[0]);
    private static final String PROB_TEXT = Messages.getString((String)"ScanTextToPdfDialog.PROB_TEXT", (String[])new String[0]);
    private Shell dialog;
    private FormToolkit toolkit;
    protected MyText txtTitle;
    protected MyText txtText;
    protected MyLabel lblProblem;
    protected Color[] probColors;
    protected int probCount;
    protected File saveFile;

    public ScanTextToPdfDialog(Shell parent, File saveFile) {
        this.saveFile = saveFile;
        this.probColors = new Color[2];
        this.probCount = 0;
        this.probColors[0] = ResourceGetter.getColor((int)200, (int)0, (int)0);
        this.probColors[1] = ResourceGetter.getColor((int)200, (int)100, (int)50);
        this.createDialog(parent);
    }

    private void createDialog(Shell parent) {
        this.dialog = new Shell(parent, 2144);
        this.dialog.setText(TITLE_DIALOG);
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        ResourceGetter.linkResourceWithWidgetLife((Object)white, (Widget)this.dialog);
        this.dialog.setBackground(white);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.spacing = 5;
        this.dialog.setLayout((Layout)layout);
        this.toolkit = UI.createToolKit((Widget)this.dialog);
        this.createChilds(this.dialog);
    }

    private void createChilds(Shell parent) {
        MyLabel lblTitle = new MyLabel((Composite)parent, TITLE, 0, this.toolkit);
        MyLabel lblText = new MyLabel((Composite)parent, TEXT, 0, this.toolkit);
        MyButton btnOk = new MyButton((Composite)parent, OKI, 8, this.toolkit);
        MyButton btnCancel = new MyButton((Composite)parent, ANNULER, 8, this.toolkit);
        this.txtTitle = new MyText((Composite)parent, this.toolkit, 0);
        this.txtText = new MyText((Composite)parent, this.toolkit, 64);
        this.lblProblem = new MyLabel((Composite)parent, "", 0, this.toolkit);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ScanTextToPdfDialog.this.ok();
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ScanTextToPdfDialog.this.cancel();
            }
        });
        Control[] tabs = new Control[]{this.txtTitle.getControl(), this.txtText.getControl(), btnOk.getControl(), btnCancel.getControl()};
        parent.setTabList(tabs);
        this.txtTitle.setFocus();
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100, -10);
        lblTitle.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblTitle.getControl(), 5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtTitle.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtTitle.getControl(), 8);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblText.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblText.getControl(), 5);
        data.left = new FormAttachment(0);
        data.width = 800;
        data.height = 200;
        this.txtText.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtText.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblProblem.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblProblem.getControl(), 20);
        data.left = new FormAttachment(0);
        btnCancel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblProblem.getControl(), 20);
        data.right = new FormAttachment(100);
        btnOk.setLayoutData((Object)data);
    }

    protected void cancel() {
        this.dialog.close();
    }

    private void ok() {
        try {
            String problem = "";
            if (StringUtils.isBlank((CharSequence)this.txtTitle.getText())) {
                problem = String.valueOf(problem) + PROB_TITLE + " ";
            }
            if (StringUtils.isBlank((CharSequence)this.txtText.getText())) {
                problem = String.valueOf(problem) + PROB_TEXT;
            }
            if (StringUtils.isNotBlank((CharSequence)problem)) {
                this.lblProblem.setText(problem);
                this.lblProblem.setForeground(this.probColors[this.probCount++ % 2]);
            } else {
                FileOutputStream file = new FileOutputStream(new File(this.saveFile, FileUtil.getFileNameWithExtension((File)new File(this.txtTitle.getText()), (String)"pdf")));
                Document document = new Document();
                PdfWriter.getInstance((Document)document, (OutputStream)file);
                document.open();
                document.add((Element)new Paragraph(this.txtText.getText()));
                document.close();
                ((OutputStream)file).close();
                this.dialog.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Incapable de g\ufffdn\ufffdrer le fichier Pdf ou autre problem dans le processus de validation.", e);
        }
    }

    public void open() {
        this.dialog.pack();
        UI.centerComposite((Composite)this.dialog, (Composite)this.dialog.getParent());
        this.dialog.open();
        UI.waitForWindowToClose((Shell)this.dialog);
    }
}

