/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.service.IEditableDataObjectDeleted;
import ca.infodata.ofys.data.middle.dataobjects.service.XSecteur;
import ca.infodata.ofys.data.middle.dataobjects.service.XTaxeDef;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.JoinList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RessourcePlugin
extends AbstractUIPlugin
implements CompletionComboAccessorClient.CompletionComboListener {
    private static final Logger logger = Logger.getLogger(RessourcePlugin.class.getName());
    public static final String PLUGIN_ID = "ca.infodata.ofys.ui.ressource";
    private static RessourcePlugin plugin;
    private final GlobalInstancesListener globalInstancesListener;
    private final List<XSecteur> secteurs;
    private final Map<Integer, XSecteur> idMapSecteur;
    private final List<XTaxeDef> taxeDefs;
    private final Map<Integer, XTaxeDef> idMapTaxeDef;
    private String codeClient;
    private final Comparator<IEditableDataObjectDeleted> comparatorDeleted;
    private static IStatusHandler statusHandler;

    static {
        statusHandler = ControlsPlugin.getDefaultStatusHandler();
    }

    public RessourcePlugin() {
        plugin = this;
        this.secteurs = new ArrayList<XSecteur>();
        this.idMapSecteur = new ConcurrentHashMap<Integer, XSecteur>();
        this.taxeDefs = new ArrayList<XTaxeDef>();
        this.idMapTaxeDef = new ConcurrentHashMap<Integer, XTaxeDef>();
        this.comparatorDeleted = new Comparator<IEditableDataObjectDeleted>(){

            @Override
            public int compare(IEditableDataObjectDeleted a, IEditableDataObjectDeleted b) {
                if (Boolean.FALSE.equals(a.getIsDeleted()) && Boolean.FALSE.equals(b.getIsDeleted())) {
                    return a.toString().compareTo(b.toString());
                }
                if (Boolean.TRUE.equals(a.getIsDeleted())) {
                    return 1;
                }
                return 1;
            }
        };
        this.globalInstancesListener = new GlobalInstancesAdapter(){

            public void sessionChanged() {
                String newCodeClient = this.getNewCodeClient();
                Log.logOperation((String)"RessourcePlugin.sessionChanged", (Object[])new Object[]{"actualCodeClient", RessourcePlugin.this.codeClient, "newCodeClient", newCodeClient});
                if (!MiscUtil.areObjectsEquals((Object)RessourcePlugin.this.codeClient, (Object)newCodeClient)) {
                    RessourcePlugin.this.codeClient = newCodeClient;
                    RessourcePlugin.this.loadClientSecteur();
                    RessourcePlugin.this.loadClientTaxeDef();
                }
            }

            private String getNewCodeClient() {
                try {
                    XSession session = Application.get().getGlobalInstances().getSession();
                    if (session != null) {
                        return session.getClient().getClientCode();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to get codeClient from xsession bug", e);
                }
                return null;
            }
        };
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Application.get().getGlobalInstances().addGlobalInstancesListener(this.globalInstancesListener);
        CompletionComboAccessorClient.addListener((String)XSecteur.type, (CompletionComboAccessorClient.CompletionComboListener)this);
        CompletionComboAccessorClient.addListener((String)XTaxeDef.type, (CompletionComboAccessorClient.CompletionComboListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        Application.get().getGlobalInstances().removeGlobalInstancesListener(this.globalInstancesListener);
        CompletionComboAccessorClient.removeListener((String)XSecteur.type, (CompletionComboAccessorClient.CompletionComboListener)this);
        CompletionComboAccessorClient.removeListener((String)XTaxeDef.type, (CompletionComboAccessorClient.CompletionComboListener)this);
        super.stop(context);
    }

    public static RessourcePlugin getDefault() {
        return plugin;
    }

    public void shouldRefresh(ICompletionComboItem item) {
        this.loadClientSecteur();
        this.loadClientTaxeDef();
    }

    private void loadClientSecteur() {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session == null) {
            this.loadClientSecteurs(null);
        } else {
            JobCallback callback = new JobCallback(Messages.getString((String)"CHARGEMENT_DES_SECTEURS", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    List list = (List)response.getObj();
                    RessourcePlugin.this.loadClientSecteurs(list);
                }

                public void exception(Exception e) {
                    logger.log(Level.WARNING, "Failed to load areas list", e);
                    RessourcePlugin.this.loadClientSecteurs(null);
                }
            };
            try {
                CompletionComboAccessorClient.getInstance().findAllAsync(session, (ICallback)callback, XSecteur.type);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to load areas list", e);
                callback.kill();
            }
        }
    }

    private void loadClientSecteurs(List<XSecteur> list) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("loading areas list \n" + list);
        }
        if (list == null) {
            Log.logOperation((String)"RessourcePlugin.loadClientSecteurs", (Object[])new Object[]{"list", null});
        } else {
            JoinList joinList = new JoinList(",");
            for (XSecteur s : list) {
                joinList.add(s.id.intValue());
            }
            Log.logOperation((String)"RessourcePlugin.loadClientSecteurs", (Object[])new Object[]{"list", joinList});
        }
        this.secteurs.clear();
        this.idMapSecteur.clear();
        if (list != null) {
            Collections.sort(list, this.comparatorDeleted);
            this.secteurs.addAll(list);
            for (XSecteur site : list) {
                this.idMapSecteur.put(site.getId(), site);
            }
        }
    }

    public List<XSecteur> getSecteurs() {
        return Collections.unmodifiableList(this.secteurs);
    }

    public XSecteur getSecteur(Integer idSecteur) {
        if (idSecteur == null) {
            return null;
        }
        XSecteur site = null;
        if (idSecteur != null) {
            site = this.idMapSecteur.get(idSecteur);
        }
        if (idSecteur != null && site == null && Application.get().getGlobalInstances().getSession() != null) {
            logger.log(Level.WARNING, "Failed to get XSecteur for id " + idSecteur + ". \n" + Log.getPrintedStackTrace());
        }
        return site;
    }

    public List<XSecteur> getSecteurs(List<Integer> ids) {
        if (ids == null) {
            return null;
        }
        ArrayList<XSecteur> list = new ArrayList<XSecteur>(ids.size());
        for (Integer id : ids) {
            list.add(this.idMapSecteur.get(id));
        }
        return list;
    }

    private void loadClientTaxeDef() {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session == null) {
            this.loadClientTaxeDefs(null);
        } else {
            JobCallback callback = new JobCallback(String.valueOf(Messages.getString((String)"CHARGEMENT", (String[])new String[0])) + " " + Messages.getString((String)"TAXE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    List list = (List)response.getObj();
                    RessourcePlugin.this.loadClientTaxeDefs(list);
                }

                public void exception(Exception e) {
                    logger.log(Level.WARNING, "Failed to load taxeDef list", e);
                    RessourcePlugin.this.loadClientTaxeDefs(null);
                }
            };
            try {
                CompletionComboAccessorClient.getInstance().findAllAsync(session, (ICallback)callback, XTaxeDef.type);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to load taxeDef list", e);
                callback.kill();
            }
        }
    }

    private void loadClientTaxeDefs(List<XTaxeDef> list) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("loading taxeDef list \n" + list);
        }
        if (list == null) {
            Log.logOperation((String)"RessourcePlugin.loadClientTaxeDefs", (Object[])new Object[]{"list", null});
        } else {
            JoinList joinList = new JoinList(",");
            for (XTaxeDef s : list) {
                joinList.add(s.id.intValue());
            }
            Log.logOperation((String)"RessourcePlugin.loadClientTaxeDefs", (Object[])new Object[]{"list", joinList});
        }
        this.taxeDefs.clear();
        this.idMapTaxeDef.clear();
        if (list != null) {
            Collections.sort(list, this.comparatorDeleted);
            this.taxeDefs.addAll(list);
            for (XTaxeDef site : list) {
                this.idMapTaxeDef.put(site.getId(), site);
            }
        }
    }

    public List<XTaxeDef> getTaxeDefs() {
        return Collections.unmodifiableList(this.taxeDefs);
    }

    public XTaxeDef getTaxeDef(Integer idTaxeDef) {
        if (idTaxeDef == null) {
            return null;
        }
        XTaxeDef site = null;
        if (idTaxeDef != null) {
            site = this.idMapTaxeDef.get(idTaxeDef);
        }
        if (idTaxeDef != null && site == null && Application.get().getGlobalInstances().getSession() != null) {
            logger.log(Level.WARNING, "Failed to get XTaxeDef for id " + idTaxeDef + ". \n" + Log.getPrintedStackTrace());
        }
        return site;
    }

    public List<XTaxeDef> getTaxeDefs(List<Integer> ids) {
        if (ids == null) {
            return null;
        }
        ArrayList<XTaxeDef> list = new ArrayList<XTaxeDef>(ids.size());
        for (Integer id : ids) {
            list.add(this.idMapTaxeDef.get(id));
        }
        return list;
    }

    public static void setDefaultStatusHandler(IStatusHandler statusHandler) {
        if (statusHandler == null) {
            throw new NullPointerException("statusHandler");
        }
        RessourcePlugin.statusHandler = statusHandler;
    }

    public static IStatusHandler getDefaultStatusHandler() {
        return statusHandler;
    }
}

