/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.export;

import ca.infodata.ofys.data.middle.dataobjects.export.XExportableField;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.h2cache.DynamicStringTableEncryptedFileSystem;
import ca.infodata.ofys.ui.person.patient.search.export.IExporter;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.date.LocalDate;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class H2Exporter
implements IExporter {
    protected DynamicStringTableEncryptedFileSystem h2;
    private int key = 0;

    public H2Exporter() throws Exception {
        File file = new File(LibPlugin.OFYS_HOME_FILE, "export" + System.currentTimeMillis());
        String filePassword = MiscUtil.randomPassword((int)16);
        this.h2 = new DynamicStringTableEncryptedFileSystem(file, filePassword);
    }

    @Override
    public void append(List<HashMap<XExportableField, Serializable>> list) throws Exception {
        for (HashMap<XExportableField, Serializable> e : list) {
            ++this.key;
            for (XExportableField field : e.keySet()) {
                Serializable value = e.get(field);
                if (value == null) {
                    this.h2.put(Integer.valueOf(this.key), field.toString(), "");
                    continue;
                }
                if (value instanceof String) {
                    this.h2.put(Integer.valueOf(this.key), field.toString(), ((String)((Object)value)).trim());
                    continue;
                }
                if (value instanceof LocalDate) {
                    this.h2.put(Integer.valueOf(this.key), field.toString(), ((LocalDate)value).formatHyphen());
                    continue;
                }
                if (!(value instanceof Map)) continue;
                Map map = (Map)((Object)value);
                for (Map.Entry e2 : map.entrySet()) {
                    this.h2.put(Integer.valueOf(this.key), (String)e2.getKey(), (String)e2.getValue());
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.h2.closeAndDelete();
    }

    @Override
    public void appendDone() throws Exception {
    }
}

