/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.export;

import ca.infodata.ofys.data.middle.dataobjects.export.XExportableField;
import ca.infodata.ofys.ui.person.patient.search.export.CsvWriter;
import ca.infodata.ofys.ui.person.patient.search.export.ExportBean;
import ca.infodata.ofys.ui.person.patient.search.export.H2Exporter;
import ca.infodata.util1.ClosureA;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;

public class CsvExporter
extends H2Exporter {
    private ExportBean bean;
    private CsvWriter csvWriter;
    private List<String> fields;
    private String[] records;

    public CsvExporter(ExportBean bean) throws Exception {
        this.bean = bean;
    }

    @Override
    public void appendDone() throws Exception {
        File file = this.bean.toFile;
        this.csvWriter = new CsvWriter(new FileOutputStream(file), ';', Charset.forName("utf8"));
        this.fields = this.h2.getCallerFields();
        final List<String> fieldOrder = Arrays.asList(XExportableField.FIRST_NAME.toString(), XExportableField.LAST_NAME.toString(), XExportableField.SEX.toString(), XExportableField.BIRTH_DATE.toString(), XExportableField.HIN.toString(), XExportableField.RECORDNUMBER.toString(), XExportableField.MOTHER_NAME.toString(), XExportableField.FATHER_NAME.toString(), XExportableField.TUTOR_NAME.toString(), XExportableField.IS_SCANNED.toString(), XExportableField.TREATING_PROFESSIONNAL.toString(), XExportableField.ADDRESSES.toString(), "Adresse", "Adresse Note", "Rue", "Ville", "Province", "Pays", "Code Postal", XExportableField.CONTACTS.toString(), "T\u00e9l\u00e9phone", "T\u00e9l\u00e9phone Note", "T\u00e9l\u00e9phone 2", "T\u00e9l\u00e9phone 2 Note", "T\u00e9l\u00e9avertisseur", "T\u00e9l\u00e9avertisseur Note", "T\u00e9l\u00e9copieur", "T\u00e9l\u00e9copieur Note", "Cellulaire/Texto", "Cellulaire/Texto Note", "Autre(s) cellulaire(s)", "Autre(s) cellulaire(s) Note", "Courriel principal", "Courriel principal Note", "Autre(s) courriel(s)", "Autre(s) courriel(s) Note", XExportableField.LAST_APPOINTMENT_DATE.toString(), XExportableField.NEXT_APPOINTMENT_DATE.toString(), XExportableField.NEXT_PATIENT_RECALL_DATE.toString(), XExportableField.SITE.toString(), XExportableField.NOTE.toString(), XExportableField.IDENTIFIERS.toString());
        Collections.sort(this.fields, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i1 = fieldOrder.indexOf(o1);
                int i2 = fieldOrder.indexOf(o2);
                if (i1 < 0 && i2 < 0) {
                    return o1.compareTo(o2);
                }
                if (i1 < 0) {
                    return 1;
                }
                if (i2 < 0) {
                    return -1;
                }
                return i1 - i2;
            }
        });
        this.records = new String[this.fields.size()];
        this.csvWriter.writeRecord(this.fields.toArray(this.records));
        this.csvWriter.flush();
        final MutableInt count = new MutableInt(0);
        this.h2.iterate((ClosureA)new ClosureA<Map<String, String>>(){

            public void execute(Map<String, String> data) {
                try {
                    int i = 0;
                    while (i < CsvExporter.this.records.length) {
                        ((CsvExporter)CsvExporter.this).records[i] = "";
                        ++i;
                    }
                    int c = 0;
                    while (c < CsvExporter.this.fields.size()) {
                        ((CsvExporter)CsvExporter.this).records[c] = data.get(CsvExporter.this.fields.get(c));
                        ++c;
                    }
                    CsvExporter.this.csvWriter.writeRecord(CsvExporter.this.records, true);
                    count.add(1);
                    if (count.intValue() % 100 == 0) {
                        CsvExporter.this.csvWriter.flush();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.csvWriter.flush();
        this.csvWriter.close();
    }
}

