/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.criteria;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.patient.TextSearchCriteria;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.criteria.Criteria;
import ca.infodata.ofys.ui.person.patient.criteria.ECrit;
import ca.infodata.ofys.ui.person.patient.criteria.Operator;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.List;

public abstract class TextSearchController {
    private Criteria cpatient;
    private Criteria csite;
    private List<Criteria> ctext = new ArrayList<Criteria>();
    private TextSearchCriteria textSearch = new TextSearchCriteria(Application.get().getGlobalInstances().getSession().getClientPreferences().getPatientRecordNumberLength().intValue());

    public boolean isFilterBySite() {
        return this.csite != null;
    }

    public void setFilterBySite(boolean b) {
        if (b) {
            this.csite = new Criteria();
            this.csite.id = ECrit.SITE;
            this.csite.operator = Operator.EQ;
            this.csite.value = SitePlugin.getDefault().getContextSiteChecked().getId();
            this.csite.svalue = SitePlugin.getDefault().getContextSiteChecked().getNameCommon();
        } else {
            this.csite = null;
        }
    }

    public boolean isOnlyInMyPatient() {
        return this.cpatient != null;
    }

    public void setOnlyInMyPatient(boolean b) {
        if (b) {
            this.cpatient = new Criteria();
            this.cpatient.id = ECrit.TREATING_PROF;
            this.cpatient.operator = Operator.EQ;
            this.cpatient.value = PersonUiPlugin.getDefault().getSessionProfessionnal().getId();
            this.cpatient.svalue = PersonUiPlugin.getDefault().getSessionProfessionnal().getName();
        } else {
            this.cpatient = null;
        }
    }

    public void setText(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            this.ctext.clear();
        } else {
            List names;
            String[] recordNumber;
            String phone;
            String nam;
            String identifier;
            Criteria c;
            this.ctext.clear();
            this.textSearch.parse(text);
            LocalDate birthdate = this.textSearch.getBirthdate();
            if (birthdate != null) {
                c = new Criteria();
                c.id = ECrit.BIRTHDATE;
                c.operator = Operator.EQ;
                c.value = birthdate;
                c.svalue = birthdate.formatHyphen();
                this.ctext.add(c);
            }
            if (StringUtils.isNotBlank((String)(identifier = this.textSearch.getIdentifier()))) {
                c = new Criteria();
                c.id = ECrit.IDENTIFIER;
                c.operator = Operator.EQ;
                c.value = identifier;
                c.svalue = identifier;
                this.ctext.add(c);
            }
            if (StringUtils.isNotBlank((String)(nam = this.textSearch.getNam()))) {
                c = new Criteria();
                c.id = ECrit.NAM;
                c.operator = Operator.LIKE;
                c.value = nam;
                c.svalue = nam;
                this.ctext.add(c);
            }
            if (StringUtils.isNotBlank((String)(phone = this.textSearch.getPhone()))) {
                c = new Criteria();
                c.id = ECrit.PHONE;
                c.operator = Operator.EQ;
                c.value = phone;
                c.svalue = phone;
                this.ctext.add(c);
            }
            if ((recordNumber = this.textSearch.getRecordNumber()) != null && recordNumber.length > 0) {
                c = new Criteria();
                c.id = ECrit.RECORD_NUMBER;
                c.operator = Operator.IN;
                c.value = recordNumber;
                c.svalue = "(" + new JoinList(", ").add(recordNumber) + ")";
                this.ctext.add(c);
            }
            if ((names = this.textSearch.getNames()) != null && names.size() > 0) {
                c = new Criteria();
                c.id = ECrit.NAME;
                c.operator = Operator.IN;
                c.value = names;
                JoinList joinList = new JoinList(", ");
                for (Object[] name : names) {
                    joinList.add((CharSequence)new JoinList(" ", name).toString());
                }
                c.svalue = "(" + joinList + ")";
                this.ctext.add(c);
            }
        }
    }

    public List<Criteria> getCriterias() {
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (this.cpatient != null) {
            list.add(this.cpatient);
        }
        if (this.csite != null) {
            list.add(this.csite);
        }
        if (this.ctext != null) {
            list.addAll(this.ctext);
        }
        return list;
    }

    public abstract void doSearch(List<Criteria> var1);
}

