/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.person.INamValidatorService;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.IDDataObject;
import ca.infodata.ofys.data.middle.dataobjects.XBasePatient;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPatientListText;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.NotFoundPatient;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PatientUtil {
    private static final Logger logger = Logger.getLogger(PatientUtil.class.getName());

    public static IPatient getIPatientOrBasePatient(Object patient) {
        if (patient == null) {
            return null;
        }
        if (NotFoundPatient.id.equals(patient)) {
            return NotFoundPatient.instance;
        }
        if (patient instanceof IPatient) {
            return (IPatient)patient;
        }
        if (patient instanceof IPatientRelated) {
            return ((IPatientRelated)patient).getPatient();
        }
        return PatientUtil.getBasePatient(patient);
    }

    public static XBasePatient getBasePatient(Object patient) {
        if (patient == null) {
            return null;
        }
        if (patient instanceof XBasePatient) {
            return (XBasePatient)patient;
        }
        if (patient instanceof XPatient) {
            return new XBasePatient((IPatient)((XPatient)patient));
        }
        if (patient instanceof IDDataObject) {
            return PatientUtil.getBasePatientSync(((IDDataObject)patient).getId());
        }
        if (patient instanceof Integer) {
            return PatientUtil.getBasePatientSync((Integer)patient);
        }
        if (patient instanceof XPatientListText) {
            return ((XPatientListText)patient).getBasePatient();
        }
        if (patient instanceof IPatientRelated) {
            return PatientUtil.getBasePatient(((IPatientRelated)patient).getPatient());
        }
        throw new IllegalArgumentException("unsupported type " + patient);
    }

    private static XBasePatient getBasePatientSync(Integer id) {
        if (id == null) {
            return null;
        }
        try {
            return PatientAccessorClient.getInstance().getBasePatientSync(id.intValue(), Application.get().getGlobalInstances().getSession(), id.intValue());
        }
        catch (Exception e) {
            MessageUtil.unexpectedExceptionMsg((Exception)e);
            return null;
        }
    }

    public static XPatient getSimplePatient(Object patient) {
        if (patient == null) {
            return null;
        }
        if (patient instanceof XPatient) {
            return (XPatient)patient;
        }
        if (patient instanceof XBasePatient) {
            return PatientUtil.getSimplePatientSync(((XBasePatient)patient).getId());
        }
        if (patient instanceof IDDataObject) {
            return PatientUtil.getSimplePatientSync(((IDDataObject)patient).getId());
        }
        if (patient instanceof Integer) {
            return PatientUtil.getSimplePatientSync((Integer)patient);
        }
        if (patient instanceof IPatientRelated) {
            return PatientUtil.getSimplePatient(((IPatientRelated)patient).getPatient());
        }
        throw new IllegalArgumentException("unsupported type " + patient);
    }

    private static XPatient getSimplePatientSync(Integer id) {
        if (id == null) {
            return null;
        }
        try {
            return PatientAccessorClient.getInstance().getSimplePatientSync(id.intValue(), Application.get().getGlobalInstances().getSession(), id.intValue());
        }
        catch (Exception e) {
            MessageUtil.unexpectedExceptionMsg((Exception)e);
            return null;
        }
    }

    public static XPatient getXPatient(Object patient) {
        if (patient == null) {
            return null;
        }
        if (patient instanceof XPatient) {
            return (XPatient)patient;
        }
        if (patient instanceof XPatientListText) {
            return ((XPatientListText)patient).getPatient();
        }
        if (patient instanceof XBasePatient) {
            return PatientUtil.getPatientSync(((XBasePatient)patient).getId());
        }
        if (patient instanceof IDDataObject) {
            return PatientUtil.getPatientSync(((IDDataObject)patient).getId());
        }
        if (patient instanceof Integer) {
            return PatientUtil.getPatientSync((Integer)patient);
        }
        throw new IllegalArgumentException("unsupported type " + patient);
    }

    private static XPatient getPatientSync(Integer id) {
        if (id == null) {
            return null;
        }
        try {
            return PatientAccessorClient.getInstance().getPatientSync(Application.get().getGlobalInstances().getSession(), id.intValue());
        }
        catch (Exception e) {
            MessageUtil.unexpectedExceptionMsg((Exception)e);
            return null;
        }
    }

    public static IStatus valid(IPatient patient, boolean showMessageToUser) {
        INamValidatorService service = PersonUiPlugin.getDefault().getNamValidatorService();
        if (service == null) {
            logger.log(Level.WARNING, "no INamValidatorService is registered");
            return Status.OK_STATUS;
        }
        IStatus status = service.valid(patient);
        if (showMessageToUser) {
            MessageUtil.show((IStatus)status);
        }
        return status;
    }
}

