/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseCommercialDrug;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.util.UserDialogSettings3;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.log.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class PatientDocumentationDialog {
    private Shell shell;
    private List<TreeItem> lstTreeItem = new ArrayList<TreeItem>();
    private XPatient patient;
    private List<XBaseCommercialDrug> lstDrugsToDocument = new ArrayList<XBaseCommercialDrug>();
    private Combo cmbLanguagePatient;
    private Button chkShowPatient;
    private Combo cmbLanguageProfessionnal;
    private Button chkShowProfessionnal;
    private Color white;
    private boolean isOk = false;
    private Tree treeChoice;
    protected boolean showPatientFrench = true;
    protected boolean showPatientEnglish = false;
    protected boolean showProfessionnalFrench = true;
    protected boolean showProfessionnalEnglish = false;
    private boolean oldValueActive = false;
    private boolean oldValueInactive = false;
    private UserDialogSettings3 patientDocPrintInfo;
    private String patDocPrintFile;

    public PatientDocumentationDialog(Shell parent, XPatient patient) {
        this.patient = patient;
        this.shell = new Shell(parent, 67680);
        this.shell.setText(Messages.getString((String)"DOCUMENTATION", (String[])new String[0]));
        this.white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        this.createControls((Composite)this.shell);
        this.getPatientDocChoice();
        this.shell.pack();
        if (this.shell.getSize().x < 350) {
            this.shell.setSize(700, this.shell.getSize().y);
        }
        Rectangle clientArea = Display.getDefault().getClientArea();
        this.shell.setLocation((clientArea.width - this.shell.getSize().x) / 2, (clientArea.height - this.shell.getSize().y) / 2);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                ResourceGetter.dispose((Object)PatientDocumentationDialog.this.white);
            }
        });
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (Display.getDefault().readAndDispatch()) continue;
            Display.getDefault().sleep();
        }
    }

    private void createControls(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginHeight = 5;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        parent.setBackground(this.white);
        this.chkShowPatient = new Button(parent, 32);
        this.chkShowPatient.setBackground(this.white);
        this.chkShowPatient.setText(Messages.getString((String)"AFFICHER_PATIENT", (String[])new String[0]));
        this.chkShowPatient.setSelection(true);
        this.chkShowPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientDocumentationDialog.this.showPatientFrench = PatientDocumentationDialog.this.chkShowPatient.getSelection() && (PatientDocumentationDialog.this.cmbLanguagePatient.getSelectionIndex() == 0 || PatientDocumentationDialog.this.cmbLanguagePatient.getSelectionIndex() == 2);
                PatientDocumentationDialog.this.showPatientEnglish = PatientDocumentationDialog.this.chkShowPatient.getSelection() && (PatientDocumentationDialog.this.cmbLanguagePatient.getSelectionIndex() == 1 || PatientDocumentationDialog.this.cmbLanguagePatient.getSelectionIndex() == 2);
                PatientDocumentationDialog.this.cmbLanguagePatient.setEnabled(PatientDocumentationDialog.this.chkShowPatient.getSelection());
            }
        });
        Label lblLanguagePatient = new Label(parent, 0);
        lblLanguagePatient.setBackground(this.white);
        lblLanguagePatient.setText(Messages.getString((String)"LANGUE_DU_PATIENT", (String[])new String[0]));
        this.cmbLanguagePatient = new Combo(parent, 8);
        this.cmbLanguagePatient.setItems(new String[]{Messages.getString((String)"FRANCAIS", (String[])new String[0]), Messages.getString((String)"ANGLAIS", (String[])new String[0]), Messages.getString((String)"TOUS", (String[])new String[0])});
        this.cmbLanguagePatient.select(0);
        this.cmbLanguagePatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientDocumentationDialog.this.showPatientFrench = PatientDocumentationDialog.this.chkShowPatient.getSelection() && (PatientDocumentationDialog.this.cmbLanguagePatient.getSelectionIndex() == 0 || PatientDocumentationDialog.this.cmbLanguagePatient.getSelectionIndex() == 2);
                PatientDocumentationDialog.this.showPatientEnglish = PatientDocumentationDialog.this.chkShowPatient.getSelection() && (PatientDocumentationDialog.this.cmbLanguagePatient.getSelectionIndex() == 1 || PatientDocumentationDialog.this.cmbLanguagePatient.getSelectionIndex() == 2);
            }
        });
        this.chkShowProfessionnal = new Button(parent, 32);
        this.chkShowProfessionnal.setBackground(this.white);
        this.chkShowProfessionnal.setText(Messages.getString((String)"AFFICHER_PROFESSIONNEL", (String[])new String[0]));
        this.chkShowProfessionnal.setSelection(true);
        this.chkShowProfessionnal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientDocumentationDialog.this.showProfessionnalFrench = PatientDocumentationDialog.this.chkShowProfessionnal.getSelection() && (PatientDocumentationDialog.this.cmbLanguageProfessionnal.getSelectionIndex() == 0 || PatientDocumentationDialog.this.cmbLanguageProfessionnal.getSelectionIndex() == 2);
                PatientDocumentationDialog.this.showProfessionnalEnglish = PatientDocumentationDialog.this.chkShowProfessionnal.getSelection() && (PatientDocumentationDialog.this.cmbLanguageProfessionnal.getSelectionIndex() == 1 || PatientDocumentationDialog.this.cmbLanguageProfessionnal.getSelectionIndex() == 2);
                PatientDocumentationDialog.this.cmbLanguageProfessionnal.setEnabled(PatientDocumentationDialog.this.chkShowProfessionnal.getSelection());
            }
        });
        Label lblLanguageProfessionnal = new Label(parent, 0);
        lblLanguageProfessionnal.setBackground(this.white);
        lblLanguageProfessionnal.setText(Messages.getString((String)"LANGUE_DU_PROFESSIONNEL", (String[])new String[0]));
        this.cmbLanguageProfessionnal = new Combo(parent, 8);
        this.cmbLanguageProfessionnal.setItems(new String[]{Messages.getString((String)"FRANCAIS", (String[])new String[0]), Messages.getString((String)"ANGLAIS", (String[])new String[0]), Messages.getString((String)"TOUS", (String[])new String[0])});
        this.cmbLanguageProfessionnal.select(0);
        this.cmbLanguageProfessionnal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientDocumentationDialog.this.showProfessionnalFrench = PatientDocumentationDialog.this.chkShowProfessionnal.getSelection() && (PatientDocumentationDialog.this.cmbLanguageProfessionnal.getSelectionIndex() == 0 || PatientDocumentationDialog.this.cmbLanguageProfessionnal.getSelectionIndex() == 2);
                PatientDocumentationDialog.this.showProfessionnalEnglish = PatientDocumentationDialog.this.chkShowProfessionnal.getSelection() && (PatientDocumentationDialog.this.cmbLanguageProfessionnal.getSelectionIndex() == 1 || PatientDocumentationDialog.this.cmbLanguageProfessionnal.getSelectionIndex() == 2);
            }
        });
        Group grpChoice = new Group(parent, 0);
        grpChoice.setBackground(this.white);
        grpChoice.setText(Messages.getString((String)"CHOIX_DES_MEDICAMENTS", (String[])new String[0]));
        grpChoice.setLayout((Layout)new FormLayout());
        this.treeChoice = new Tree((Composite)grpChoice, 290);
        this.treeChoice.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PatientDocumentationDialog.this.doTreeChecked((Tree)e.widget);
            }
        });
        Button cmdAll = new Button(parent, 8);
        cmdAll.setText(Messages.getString((String)"SELECTIONNEZ_TOUS", (String[])new String[0]));
        cmdAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator i = PatientDocumentationDialog.this.lstTreeItem.iterator();
                while (i.hasNext()) {
                    ((TreeItem)i.next()).setChecked(((Button)e.widget).getText().equals(Messages.getString((String)"SELECTIONNEZ_TOUS", (String[])new String[0])));
                }
                ((Button)e.widget).setText(((Button)e.widget).getText().equals(Messages.getString((String)"SELECTIONNEZ_TOUS", (String[])new String[0])) ? Messages.getString((String)"DESELECTIONNEZ_TOUS", (String[])new String[0]) : Messages.getString((String)"SELECTIONNEZ_TOUS", (String[])new String[0]));
            }
        });
        Button cmdOk = new Button(parent, 8);
        cmdOk.setText(Messages.getString((String)"OBTENIR_DOCUMENTATION", (String[])new String[0]));
        cmdOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientDocumentationDialog.this.onOk();
            }
        });
        Button cmdCancel = new Button(parent, 8);
        cmdCancel.setText(Messages.getString((String)"ANNULER", (String[])new String[0]));
        cmdCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientDocumentationDialog.this.onCancel();
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(5);
        data.top = new FormAttachment(0);
        this.chkShowPatient.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(5);
        data.top = new FormAttachment((Control)this.chkShowPatient);
        lblLanguagePatient.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(5);
        data.right = new FormAttachment(45);
        data.top = new FormAttachment((Control)lblLanguagePatient);
        this.cmbLanguagePatient.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(50);
        data.right = new FormAttachment(95);
        data.top = new FormAttachment(0);
        this.chkShowProfessionnal.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(50);
        data.top = new FormAttachment((Control)this.chkShowProfessionnal);
        lblLanguageProfessionnal.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(50);
        data.right = new FormAttachment(95);
        data.top = new FormAttachment((Control)lblLanguageProfessionnal);
        this.cmbLanguageProfessionnal.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(5);
        data.right = new FormAttachment(95);
        data.top = new FormAttachment((Control)this.cmbLanguagePatient);
        data.height = 450;
        grpChoice.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(5);
        data.top = new FormAttachment((Control)grpChoice);
        cmdAll.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100, -1);
        this.treeChoice.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100);
        data.top = new FormAttachment((Control)cmdAll);
        data.width = MyButton.getStandardButtonWidth();
        cmdCancel.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)cmdCancel);
        data.top = new FormAttachment((Control)cmdAll);
        data.width = MyButton.getStandardButtonWidth() + 40;
        cmdOk.setLayoutData((Object)data);
        this.fillListMedications();
    }

    private void fillListMedications() {
    }

    protected void doTreeChecked(Tree tree) {
        int j;
        TreeItem[] items;
        if (tree.getItem(0).getChecked() != this.oldValueActive) {
            items = tree.getItem(0).getItems();
            j = 0;
            while (j < items.length) {
                items[j].setChecked(tree.getItem(0).getChecked());
                ++j;
            }
            this.oldValueActive = tree.getItem(0).getChecked();
        }
        if (tree.getItem(1).getChecked() != this.oldValueInactive) {
            items = tree.getItem(1).getItems();
            j = 0;
            while (j < items.length) {
                items[j].setChecked(tree.getItem(1).getChecked());
                ++j;
            }
            this.oldValueInactive = tree.getItem(1).getChecked();
        }
    }

    private void onOk() {
        if (this.lstTreeItem.size() > 0) {
            for (TreeItem currentTreeItem : this.lstTreeItem) {
                if (!currentTreeItem.getChecked()) continue;
                XBaseCommercialDrug drug = (XBaseCommercialDrug)currentTreeItem.getData();
                this.lstDrugsToDocument.add(drug);
            }
            this.isOk = true;
            this.setPatientDocChoice();
            this.shell.close();
        }
    }

    private void setPatientDocChoice() {
        this.patDocPrintFile = String.valueOf(LibPlugin.OFYS_HOME) + ".patientDocPrint.xml";
        this.patientDocPrintInfo = new UserDialogSettings3("patientDocPrint");
        this.patientDocPrintInfo.put("SPat", this.chkShowPatient.getSelection());
        this.patientDocPrintInfo.put("SPro", this.chkShowProfessionnal.getSelection());
        this.patientDocPrintInfo.put("LPat", this.cmbLanguagePatient.getSelectionIndex());
        this.patientDocPrintInfo.put("LPro", this.cmbLanguageProfessionnal.getSelectionIndex());
        try {
            this.patientDocPrintInfo.save(this.patDocPrintFile);
        }
        catch (IOException e2) {
            Log.severe((String)"Exception Catch\ufffd", (Exception)e2);
        }
    }

    private void getPatientDocChoice() {
        this.patientDocPrintInfo = new UserDialogSettings3(".patientDocPrint.xml");
        this.patDocPrintFile = String.valueOf(LibPlugin.OFYS_HOME) + ".patientDocPrint.xml";
        if (new File(this.patDocPrintFile).exists()) {
            try {
                this.patientDocPrintInfo.load(this.patDocPrintFile);
                this.chkShowPatient.setSelection(this.patientDocPrintInfo.get("SPat").equals("true"));
                this.chkShowProfessionnal.setSelection(this.patientDocPrintInfo.get("SPro").equals("true"));
                this.cmbLanguageProfessionnal.setEnabled(this.chkShowProfessionnal.getSelection());
                this.cmbLanguagePatient.setEnabled(this.chkShowPatient.getSelection());
                this.cmbLanguagePatient.select(this.patientDocPrintInfo.getInt("LPat"));
                this.cmbLanguageProfessionnal.select(this.patientDocPrintInfo.getInt("LPro"));
                this.showProfessionnalFrench = this.chkShowProfessionnal.getSelection() && (this.cmbLanguageProfessionnal.getSelectionIndex() == 0 || this.cmbLanguageProfessionnal.getSelectionIndex() == 2);
                this.showProfessionnalEnglish = this.chkShowProfessionnal.getSelection() && (this.cmbLanguageProfessionnal.getSelectionIndex() == 1 || this.cmbLanguageProfessionnal.getSelectionIndex() == 2);
                this.showPatientFrench = this.chkShowPatient.getSelection() && (this.cmbLanguagePatient.getSelectionIndex() == 0 || this.cmbLanguagePatient.getSelectionIndex() == 2);
                this.showPatientEnglish = this.chkShowPatient.getSelection() && (this.cmbLanguagePatient.getSelectionIndex() == 1 || this.cmbLanguagePatient.getSelectionIndex() == 2);
            }
            catch (IOException e2) {
                Log.severe((String)"Exception Catch\ufffd", (Exception)e2);
            }
        }
    }

    private void onCancel() {
        this.shell.close();
    }

    public List<XBaseCommercialDrug> getDrugsToDocument() {
        return this.lstDrugsToDocument;
    }

    public boolean isOkPressed() {
        return this.isOk;
    }

    public boolean showPatientFrench() {
        return this.showPatientFrench;
    }

    public boolean showPatientEnglish() {
        return this.showPatientEnglish;
    }

    public boolean showProfessionnalFrench() {
        return this.showProfessionnalFrench;
    }

    public boolean showProfessionnalEnglish() {
        return this.showProfessionnalEnglish;
    }
}

