/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.menu;

import ca.infodata.ofys.data.dataaccess.UserAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XBasePerson;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.menu.element.EmployeeElements;
import ca.infodata.ofys.ui.person.menu.element.ProfessionnalElements;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public class ListUserBlocked
implements ITreeElements {
    private static final Logger logger = Logger.getLogger(ListUserBlocked.class.getName());
    private ITreeElements parent;
    private ITreeElements[] child;
    public int childrenNumber = -1;

    public ListUserBlocked(ITreeElements parent) {
        this.parent = parent;
    }

    public Object[] getChildren() {
        if (this.child == null) {
            ArrayList<Object> list = new ArrayList<Object>();
            List persons = null;
            try {
                persons = UserAccessorClient.getInstance().getBlockedUsers();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "ListUserBlocked.getChildren", e);
            }
            if (persons != null) {
                for (XBasePerson p : persons) {
                    if (p.toString().startsWith("Importation") || p.toString().startsWith("Infodata")) continue;
                    if (p instanceof XBaseProfessionnal) {
                        list.add((Object)new ProfessionnalElements(this, (XBaseProfessionnal)p));
                        continue;
                    }
                    if (!(p instanceof XBaseEmployee)) continue;
                    list.add(new EmployeeElements(this, (XBaseEmployee)p));
                }
                Collections.sort(list, new Comparator<ITreeElements>(){

                    @Override
                    public int compare(ITreeElements o1, ITreeElements o2) {
                        return StringUtils.compareAscii((String)o1.getText(), (String)o2.getText());
                    }
                });
                this.child = new ITreeElements[list.size()];
                list.toArray(this.child);
            }
        }
        return this.child;
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getText() {
        return Messages.getString((String)"UTILISATEURS_BLOQUES", (String[])new String[0]);
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/person_lock.gif");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public void setParent(ITreeElements parent) {
        this.parent = parent;
    }

    public ITreeElements getElementToRefresh() {
        return this;
    }

    public void showContextMenu(Control control) {
    }

    public int hashCode() {
        return new String(String.valueOf(this.parent.hashCode()) + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ListUserBlocked && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public int getChildrenNumberForPastille() {
        return this.childrenNumber;
    }
}

