/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.group;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.PreferencesAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XBasePerson;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.XUserForSelection;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.FontAwareTable;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.ICancelablePart;
import ca.infodata.ofys.ui.controls.ISaveablePart;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMasks;
import ca.infodata.ofys.ui.controls.ProviderAAR;
import ca.infodata.ofys.ui.controls.TableDataAdapter;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.user.UserTableForSelection;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PersonGroupEditor
extends BaseEditor
implements ISaveablePart,
ICancelablePart {
    private MyMaskedText txtName;
    private MyButton btnActif;
    private MyButton chkIsRvsqGroupeTravail;
    private FontAwareSection sectionPerson;
    private FontAwareTable tblPerson;
    private TableDataAdapter<XBasePerson> tblPersonAdapter;
    private MyButton btnAddUser;
    private MyButton btnRemoveUser;

    public void createMyControl(Composite parent) {
        TableColumn c;
        MyLabel lblName = new MyLabel(parent, String.valueOf(Messages.getString((String)"NOM", (String[])new String[0])) + " : ", 131072, this.toolkit);
        this.txtName = new MyMaskedText(parent, this.toolkit);
        this.txtName.setMask(MyMasks.standardText);
        this.txtName.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this, 24){

            public void edited(Event e) {
                PersonGroupEditor.this.getPersonGroup().setName(StringUtils.trim((String)PersonGroupEditor.this.txtName.getText()));
            }
        });
        this.btnActif = new MyButton(parent, Messages.getString((String)"ACTIF", (String[])new String[0]), 32, this.toolkit);
        this.btnActif.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this, 13){

            public void edited(Event e) {
                PersonGroupEditor.this.getPersonGroup().setIsDeleted(Boolean.valueOf(!PersonGroupEditor.this.btnActif.getSelection()));
            }
        });
        this.chkIsRvsqGroupeTravail = new MyButton(parent, Messages.getString((String)"RVSQ_GROUP_TRAV", (String[])new String[0]), 32, this.toolkit);
        this.chkIsRvsqGroupeTravail.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this, 13){

            public void edited(Event e) {
                if (PersonGroupEditor.this.getPersonGroup().getUpdateNumber() == null && PersonGroupEditor.this.chkIsRvsqGroupeTravail.getSelection()) {
                    PersonGroupEditor.this.getPersonGroup().setUpdateNumber(new Integer(-1));
                }
            }
        });
        this.sectionPerson = new FontAwareSection(parent, 64, this.toolkit);
        this.sectionPerson.setText(Messages.getString((String)"PERSONNES", (String[])new String[0]));
        FontAwareComposite compPerson = new FontAwareComposite((Composite)this.sectionPerson, 0);
        this.toolkit.adapt((Composite)compPerson);
        this.sectionPerson.setClient((Control)compPerson);
        this.tblPerson = new FontAwareTable((Composite)compPerson, 2048, this.toolkit);
        this.tblPerson.setHeaderVisible(true);
        this.tblPerson.setLinesVisible(true);
        this.tblPersonAdapter = new TableDataAdapter((Table)this.tblPerson);
        if (Application.get().getGlobalInstances().inDebugMode()) {
            c = this.tblPersonAdapter.addColumn("IDPERSON");
            c.setWidth(100);
        }
        c = this.tblPersonAdapter.addColumn(Messages.getString((String)"NOM", (String[])new String[0]));
        c.setWidth(200);
        c = this.tblPersonAdapter.addColumn(Messages.getString((String)"TYPE", (String[])new String[0]));
        c.setWidth(200);
        this.tblPersonAdapter.setItemProvider((ProviderAAR)new ProviderAAR<XBasePerson, Table, TableItem>(){

            public TableItem get(XBasePerson a, Table b) {
                TableItem item = new TableItem(b, -1);
                int i = 0;
                if (Application.get().getGlobalInstances().inDebugMode()) {
                    item.setText(i++, String.valueOf(a.getIdPerson()));
                }
                item.setText(i++, a.getName());
                item.setText(i++, this.getType(a));
                return item;
            }

            private String getType(XBasePerson e) {
                if (e instanceof XBaseProfessionnal) {
                    return ((XBaseProfessionnal)e).getProfessionalType().toString();
                }
                if (e instanceof XBaseEmployee) {
                    return ((XBaseEmployee)e).getEmployeeType().toString();
                }
                return null;
            }
        });
        this.btnAddUser = new MyButton((Composite)compPerson, "", 8, this.toolkit);
        this.btnAddUser.setImage(ResourceGetter.getImage((String)"images/add.png"));
        this.btnAddUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final XPersonGroup group = PersonGroupEditor.this.getPersonGroup();
                final UserTableForSelection table = UserTableForSelection.openNewDialog(PersonGroupEditor.this.getSite().getShell());
                table.setFillPredicate(new PredicateA<XUserForSelection>(){

                    public boolean evaluate(XUserForSelection t) {
                        return t.personId != null && (group.getPersons() == null || !group.getPersons().contains(t.personId));
                    }
                });
                table.fill(true);
                if (table != null) {
                    table.getControl().addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDoubleClick(MouseEvent e) {
                            XUserForSelection user = (XUserForSelection)table.getAdapter().getSelection3();
                            if (user != null) {
                                XPersonGroup group = PersonGroupEditor.this.getPersonGroup();
                                if (group.getPersons() == null) {
                                    group.setPersons(new HashSet());
                                }
                                group.getPersons().add(user.personId);
                                group.setUpdated();
                                table.getAdapter().remove((Object)user);
                                PersonGroupEditor.this.showAllDataObject();
                            }
                        }
                    });
                }
            }
        });
        this.btnRemoveUser = new MyButton((Composite)compPerson, "", 8, this.toolkit);
        this.btnRemoveUser.setImage(ResourceGetter.getImage((String)"images/delete_edit.gif"));
        this.btnRemoveUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selection = PersonGroupEditor.this.tblPersonAdapter.getSelection();
                if (selection != null) {
                    XPersonGroup group = PersonGroupEditor.this.getPersonGroup();
                    if (group.getPersons() == null) {
                        group.setPersons(new HashSet());
                    }
                    for (XBasePerson person : selection) {
                        group.getPersons().remove(person.getIdPerson());
                    }
                    group.setUpdated();
                    PersonGroupEditor.this.showAllDataObject();
                }
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(0);
        lblName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(lblName.getControl());
        data.width = 300;
        this.txtName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl());
        data.left = new FormAttachment(0);
        this.btnActif.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl());
        data.left = new FormAttachment(this.btnActif.getControl(), 10);
        this.chkIsRvsqGroupeTravail.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnActif.getControl(), 10);
        data.left = new FormAttachment(0);
        this.sectionPerson.setLayoutData((Object)data);
        layout = new FormLayout();
        layout.spacing = 5;
        compPerson.setLayout((Layout)layout);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = 600;
        data.height = 300;
        this.tblPerson.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.tblPerson);
        this.btnAddUser.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnAddUser.getControl());
        data.left = new FormAttachment((Control)this.tblPerson);
        this.btnRemoveUser.setLayoutData((Object)data);
    }

    public void setPartName(String partName) {
        XPersonGroup f = this.getPersonGroup();
        if (f != null) {
            partName = f.getId() == null ? Messages.getString((String)"NOUVEAU_GROUPE_DE_PERSONNES", (String[])new String[0]) : String.valueOf(Messages.getString((String)"GROUPE", (String[])new String[0])) + " " + f.getName();
        }
        super.setPartName(partName);
    }

    public Image getTitleImage() {
        return ResourceGetter.getImage((String)"images/persons-icon32.png");
    }

    private XPersonGroup getPersonGroup() {
        EditorInput input = (EditorInput)this.getEditorInput();
        return input == null ? null : (input.getCompleteDataObject() == null ? null : (XPersonGroup)input.getCompleteDataObject());
    }

    public void setFocus() {
        this.setToolBarStatus();
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/persons-icon32.png");
    }

    public void initDataOverride() {
        EditableDataObject dataObject = (EditableDataObject)((EditorInput)this.getEditorInput()).getDataObject();
        if (!(dataObject instanceof XPersonGroup)) {
            throw new IllegalStateException("Only XPersonGroup EditorInput is supported");
        }
        this.initializeCompleteDataObject(dataObject);
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return PreferencesAccessorClient.getInstance();
    }

    public boolean isDataDirty() {
        XPersonGroup s = this.getPersonGroup();
        return s != null && s.isDirty();
    }

    public void setToolBarStatus() {
    }

    public void showDataObject() {
        XPersonGroup group = this.getPersonGroup();
        if (group == null) {
            this.txtName.setEnabled(false);
            this.btnActif.setEnabled(false);
            this.tblPerson.setEnabled(false);
            this.txtName.clear();
            this.btnActif.setSelection(false);
            this.chkIsRvsqGroupeTravail.setSelection(false);
            this.tblPersonAdapter.setItems(null);
        } else {
            this.txtName.setEnabled(true);
            this.btnActif.setEnabled(true);
            this.tblPerson.setEnabled(true);
            this.txtName.setText(group.getName());
            this.btnActif.setSelection(!Boolean.TRUE.equals(group.getIsDeleted()));
            this.chkIsRvsqGroupeTravail.setSelection(group.getUpdateNumber() != null);
            this.chkIsRvsqGroupeTravail.setEnabled(group.getUpdateNumber() == null);
            Set persons = group.getPersons();
            if (persons == null || persons.isEmpty()) {
                this.tblPersonAdapter.setItems(null);
            } else {
                ArrayList<XBasePerson> list = new ArrayList<XBasePerson>();
                for (Integer idPerson : persons) {
                    XBasePerson person = PersonUiPlugin.getDefault().getBasePersonByIdPerson(idPerson);
                    if (person == null) continue;
                    list.add(person);
                }
                Collections.sort(list, new Comparator<XBasePerson>(){

                    @Override
                    public int compare(XBasePerson o1, XBasePerson o2) {
                        return StringUtils.compareAscii((String)o1.getName(), (String)o2.getName());
                    }
                });
                this.tblPersonAdapter.setItems(list);
            }
        }
    }
}

