/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.actions;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonMultiEditorFactory;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class OpenPatientAction
implements IWorkbenchWindowActionDelegate {
    private static IAction action;
    private IWorkbenchWindow window;
    private static boolean tempEnable;
    private Image icon;
    private Image iconGray;

    static {
        tempEnable = true;
    }

    public void dispose() {
        if (this.icon != null) {
            ResourceGetter.dispose((Object)this.icon);
        }
        if (this.iconGray != null) {
            ResourceGetter.dispose((Object)this.iconGray);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        IPatient patient;
        IEditorPart activeEditor = this.window.getActivePage().getActiveEditor();
        if (activeEditor instanceof IPatientRelated && (patient = ((IPatientRelated)activeEditor).getPatient()) != null) {
            if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().getSession().getClientPreferences() != null && Application.get().getGlobalInstances().getSession().getClientPreferences().isMultiplePatientWindows()) {
                PersonMultiEditorFactory.openPatient(patient);
            } else {
                BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)patient), (String)PatientMultiEditor.class.getName());
            }
        }
    }

    public void selectionChanged(final IAction action, ISelection selection) {
        if (!UI.isCurrentThreadIsUIThread()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    OpenPatientAction.this.refresh(action);
                }
            });
        } else {
            this.refresh(action);
        }
    }

    private void refresh(IAction action) {
        OpenPatientAction.action = action;
        action.setEnabled(tempEnable);
        this.icon = ResourceGetter.getImage((String)"images/persons-icon16.png");
        this.iconGray = ResourceGetter.getGrayImage((String)"images/persons-icon16.png");
        action.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.icon));
        action.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)this.iconGray));
    }

    public static void setEnabled(boolean value) {
        if (action != null) {
            action.setEnabled(value);
        }
        tempEnable = value;
    }
}

