/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ProfessionnalAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.ObjectCache;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.XPersonReplacement;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Stream;

public class ReplacementCache
extends ObjectCache<XPersonReplacement> {
    private static final String TYPE = "replacement";
    private IConsumerListenerImplementation listener = new IConsumerListenerImplementation();

    public ReplacementCache() {
        super(TYPE);
        Application.get().getGlobalInstances().getNotificationSystem().addListener((IConsumerListener)this.listener);
    }

    protected void load(int uniqueKey, XSession session, ICallback callback) throws Exception {
        ProfessionnalAccessorClient.getInstance().findAllPersonReplacements(uniqueKey, session, callback);
    }

    protected void add(Map<ObjectCache.Key, XPersonReplacement> map, XPersonReplacement e) {
        if (e != null) {
            map.put(new ObjectCache.Key(TYPE, Integer.valueOf(e.hashCode())), e);
        }
    }

    public XPersonReplacement getById(Integer id, boolean logIfNotFound) {
        return this.getById(id, logIfNotFound, true);
    }

    public XPersonReplacement getById(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XPersonReplacement)this.get(new ObjectCache.Key(TYPE, id), logIfNotFound, mustTryToFindServer);
    }

    protected XPersonReplacement loadSync(XSession session, ObjectCache.Key key) throws Exception {
        if (key == null) {
            return null;
        }
        logger.log(Level.SEVERE, "unsupported for now " + key);
        return null;
    }

    public Stream<XPersonReplacement> getAll() {
        return this.getMap().values().stream();
    }

    protected void loadSync(int uniqueKey, XSession session, ICallback callback) throws Exception {
        ProfessionnalAccessorClient.getInstance().findAllPersonReplacementsSync(uniqueKey, session, callback);
    }

    private final class IConsumerListenerImplementation
    implements IConsumerListener {
        private IConsumerListenerImplementation() {
        }

        public void handle(DataObjectUpdatedNotification notification) {
            try {
                IDataObject object;
                if (notification != null && (object = notification.getObject()) instanceof XPersonReplacement) {
                    ReplacementCache.this.add((Map<ObjectCache.Key, XPersonReplacement>)ReplacementCache.this.getMap(), (XPersonReplacement)object);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in IConsumerListenerImplementation.handle", e);
            }
        }

        public void handleOther(Notification notification) {
        }

        public void forceRefresh() {
            try {
                ReplacementCache.this.reload(true);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in ReplacementCache.forceRefresh", e);
            }
        }
    }
}

