/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util.collection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.nightlabs.util.collection.MapChangedEvent;
import org.nightlabs.util.collection.MapChangedListener;

public class NotifyingMap<K, V>
extends HashMap<K, V> {
    private Set<MapChangedListener> listeners = null;

    public NotifyingMap() {
        this.init();
    }

    public NotifyingMap(int initialCapacity) {
        super(initialCapacity);
        this.init();
    }

    protected void init() {
        this.listeners = new HashSet<MapChangedListener>();
    }

    public void addMapChangedListener(MapChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeMapChangedListener(MapChangedListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireMapChangedEvent(MapChangedEvent event) {
        for (MapChangedListener listener : this.listeners) {
            listener.mapChanged(event);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.fireMapChangedEvent(new MapChangedEvent(MapChangedEvent.MapChange.CLEAR, this));
    }

    @Override
    public V put(K key, V value) {
        this.fireMapChangedEvent(new MapChangedEvent<K, V>(MapChangedEvent.MapChange.PUT, this, key, value));
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.fireMapChangedEvent(new MapChangedEvent(MapChangedEvent.MapChange.PUT_ALL, this));
        super.putAll(m);
    }

    @Override
    public V remove(Object key) {
        this.fireMapChangedEvent(new MapChangedEvent(MapChangedEvent.MapChange.REMOVE, this, key));
        return super.remove(key);
    }
}

