/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.print.PrintServiceLookup;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.View;
import org.nightlabs.print.DocumentPrinter;
import org.nightlabs.print.PrintUtil;
import org.nightlabs.print.PrinterConfiguration;

public class HTMLDocumentPrinter
implements DocumentPrinter {
    private OffScreenJTextPane pane;
    private PrinterConfiguration printerConfiguration;

    @Override
    public void printDocument(File file) throws PrinterException {
        if (this.pane == null) {
            this.pane = new OffScreenJTextPane();
            Frame frame = new Frame();
            frame.setLayout(new BorderLayout());
            JScrollPane editorScrollPane = new JScrollPane(this.pane);
            editorScrollPane.setVerticalScrollBarPolicy(22);
            editorScrollPane.setPreferredSize(new Dimension(250, 145));
            editorScrollPane.setMinimumSize(new Dimension(10, 10));
            frame.add((Component)editorScrollPane, "Center");
            frame.setSize(400, 600);
            frame.setVisible(true);
        }
        try {
            this.pane.initPrinting(file);
        }
        catch (Exception e) {
            throw new PrinterException("Failed loading HTML " + e.getMessage());
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.printerConfiguration.getPrintServiceName() != null) {
            printerJob.setPrintService(PrintUtil.lookupPrintService(this.printerConfiguration.getPrintServiceName()));
        } else {
            printerJob.setPrintService(PrintServiceLookup.lookupDefaultPrintService());
        }
        if (this.printerConfiguration.getPageFormat() != null) {
            printerJob.setPrintable(this.pane, this.printerConfiguration.getPageFormat());
        } else {
            printerJob.setPrintable(this.pane);
        }
    }

    @Override
    public void configure(PrinterConfiguration printerConfiguration) throws PrinterException {
        this.printerConfiguration = printerConfiguration;
    }

    @Override
    public PrinterConfiguration getConfiguration() {
        return this.printerConfiguration;
    }

    public static class OffScreenJTextPane
    extends JEditorPane
    implements Printable {
        private static final long serialVersionUID = 1L;
        private int currentPage;
        private double pageEndY;
        private double pageStartY;
        private boolean scaleToWidth = false;

        public OffScreenJTextPane() {
            this.setEditable(false);
        }

        public void initPrinting(File htmlFile) throws MalformedURLException, IOException {
            this.setPage(htmlFile.toURL());
            this.resetPrintPosTracker();
        }

        private void resetPrintPosTracker() {
            this.currentPage = -1;
            this.pageEndY = 0.0;
            this.pageStartY = 0.0;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            double scale = 1.0;
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.setSize((int)pageFormat.getImageableWidth(), Integer.MAX_VALUE);
            this.validate();
            View rootView = this.getUI().getRootView(this);
            if (this.scaleToWidth && this.getMinimumSize().getWidth() > pageFormat.getImageableWidth()) {
                scale = pageFormat.getImageableWidth() / this.getMinimumSize().getWidth();
                graphics2D.scale(scale, scale);
            }
            graphics2D.setClip((int)(pageFormat.getImageableX() / scale), (int)(pageFormat.getImageableY() / scale), (int)(pageFormat.getImageableWidth() / scale), (int)(pageFormat.getImageableHeight() / scale));
            if (pageIndex > this.currentPage) {
                this.currentPage = pageIndex;
                this.pageStartY += this.pageEndY;
                this.pageEndY = graphics2D.getClipBounds().getHeight();
            }
            graphics2D.translate(graphics2D.getClipBounds().getX(), graphics2D.getClipBounds().getY());
            Rectangle currentViewBounds = new Rectangle(0, (int)(-this.pageStartY), (int)this.getMinimumSize().getWidth(), (int)this.getPreferredSize().getHeight());
            if (this.printView(graphics2D, currentViewBounds, rootView)) {
                return 0;
            }
            return 1;
        }

        protected boolean printView(Graphics2D graphics2D, Shape viewBounds, View view) {
            boolean pageExists = false;
            Rectangle clipBounds = graphics2D.getClipBounds();
            if (view.getViewCount() > 0) {
                int i = 0;
                while (i < view.getViewCount()) {
                    View childView;
                    Shape childBounds = view.getChildAllocation(i, viewBounds);
                    if (childBounds != null && this.printView(graphics2D, childBounds, childView = view.getView(i))) {
                        pageExists = true;
                    }
                    ++i;
                }
            } else if (viewBounds.getBounds().getMaxY() >= clipBounds.getY()) {
                pageExists = true;
                if (viewBounds.getBounds().getHeight() > clipBounds.getHeight() && viewBounds.intersects(clipBounds)) {
                    view.paint(graphics2D, clipBounds);
                } else if (viewBounds.getBounds().getY() >= clipBounds.getY()) {
                    if (viewBounds.getBounds().getMaxY() <= clipBounds.getMaxY()) {
                        view.paint(graphics2D, viewBounds);
                    } else if (viewBounds.getBounds().getY() < this.pageEndY) {
                        this.pageEndY = viewBounds.getBounds().getY();
                    }
                }
            }
            return pageExists;
        }
    }
}

