/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nightlabs.io.DataBufferInputStream;
import org.nightlabs.io.DataBufferOutputStream;
import org.nightlabs.util.Utils;

public class DataBuffer {
    protected static final int defaultMaxSizeForRAM = 0x400000;
    protected static final byte MODE_RAM = 0;
    protected static final byte MODE_FILE = 1;
    protected byte mode = 0;
    public long expectedSize;
    public int maxSizeForRAM;
    protected byte[] data;
    protected File file = null;
    protected long length = 0L;
    OutputStream os = null;

    public DataBuffer() throws FileNotFoundException, IOException {
        this(1024L);
    }

    public DataBuffer(long expectedSize, InputStream in) throws FileNotFoundException, IOException {
        this(expectedSize, 0x400000, in);
    }

    public DataBuffer(long expectedSize, int maxSizeForRAM, InputStream in) throws FileNotFoundException, IOException {
        this(expectedSize, maxSizeForRAM);
        try (OutputStream out = this.createOutputStream();){
            Utils.transferStreamData(in, out);
        }
    }

    public DataBuffer(InputStream in) throws FileNotFoundException, IOException {
        this(1024L, in);
    }

    public DataBuffer(long expectedSize, String _fileName) throws FileNotFoundException, IOException {
        this(expectedSize, 0x400000, new File(_fileName));
    }

    public DataBuffer(long expectedSize, File _file) throws FileNotFoundException, IOException {
        this(expectedSize, 0x400000, _file);
    }

    public DataBuffer(long expectedSize, int maxSizeForRAM, String _fileName) throws FileNotFoundException, IOException {
        this(expectedSize, maxSizeForRAM, new File(_fileName));
    }

    public DataBuffer(long expectedSize, int maxSizeForRAM) throws FileNotFoundException, IOException {
        this(expectedSize, maxSizeForRAM, (File)null);
    }

    public DataBuffer(long expectedSize, int maxSizeForRAM, File _file) throws FileNotFoundException, IOException {
        this.expectedSize = expectedSize;
        this.maxSizeForRAM = maxSizeForRAM;
        this.file = _file;
        if (expectedSize > (long)maxSizeForRAM || this.file != null && this.file.exists()) {
            this.mode = 1;
        }
        if (this.mode == 1) {
            if (this.file == null) {
                this.file = File.createTempFile("DataBuffer", ".tmp");
            }
            this.length = this.file.length();
        } else {
            this.data = new byte[(int)expectedSize];
        }
    }

    public DataBuffer(long expectedSize) throws FileNotFoundException, IOException {
        this(expectedSize, 0x400000, (File)null);
    }

    protected FileInputStream createFileInputStream() throws FileNotFoundException {
        if (this.mode != 1) {
            throw new IllegalStateException("Cannot return a FileInputStream when not in MODE_FILE!");
        }
        return new FileInputStream(this.file);
    }

    public InputStream createInputStream() throws IOException {
        if (this.mode == 1) {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        return new DataBufferInputStream(this);
    }

    public OutputStream createOutputStream() throws IOException {
        return new DataBufferOutputStream(this);
    }

    protected void switchModeToFile() throws IOException {
        if (this.mode == 1) {
            return;
        }
        if (this.file == null) {
            this.file = File.createTempFile("DataBuffer", ".tmp");
        }
        this.os = new BufferedOutputStream(new FileOutputStream(this.file, false));
        if (this.length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length is too big! Switching mode to file should have happened earlier!");
        }
        this.os.write(this.data, 0, (int)this.length);
        this.mode = 1;
        this.data = null;
    }

    protected void closeOutputStream() throws IOException {
        if (this.os != null) {
            this.os.close();
            this.os = null;
        }
    }

    protected void flushOutputStream() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
    }

    protected void write(byte[] b, int off, int len) throws IOException {
        if (this.mode == 1) {
            if (this.os == null) {
                this.os = new FileOutputStream(this.file, true);
            }
            this.os.write(b, off, len);
        } else if (this.length + (long)len > (long)this.maxSizeForRAM) {
            this.switchModeToFile();
            this.os.write(b, off, len);
        } else {
            if ((long)this.data.length < this.length + (long)len) {
                byte[] tmpData = new byte[((int)this.length + len) * 8 / 6];
                System.arraycopy(this.data, 0, tmpData, 0, (int)this.length);
                this.data = tmpData;
            }
            System.arraycopy(b, off, this.data, (int)this.length, len);
        }
        this.length += (long)len;
    }

    public long size() {
        return this.length;
    }

    public void vomitFile(String dest) throws IOException {
        this.vomitFile(new File(dest));
    }

    public void vomitFile(File dest) throws IOException {
        this.closeOutputStream();
        FileOutputStream o = new FileOutputStream(dest);
        if (this.data != null) {
            o.write(this.data);
        } else {
            int bytesRead;
            FileInputStream i = new FileInputStream(this.file);
            byte[] b = new byte[8192];
            while ((bytesRead = i.read(b)) > 0) {
                o.write(b, 0, bytesRead);
            }
        }
        o.close();
    }

    public byte[] createByteArray() throws IOException {
        byte[] res;
        block9: {
            if (this.length > Integer.MAX_VALUE) {
                throw new ArrayIndexOutOfBoundsException("This DataBuffer contains too much data for a byte array!");
            }
            res = new byte[(int)this.length];
            if (this.mode == 0) {
                System.arraycopy(this.data, 0, res, 0, res.length);
            } else {
                if (this.mode == 1) {
                    try (InputStream in = this.createInputStream();){
                        int bytesRead;
                        int pos = 0;
                        do {
                            if ((bytesRead = in.read(res, pos, res.length - pos)) <= 0) continue;
                            pos += bytesRead;
                        } while (bytesRead >= 0 && pos < res.length);
                        if (pos < res.length) {
                            throw new IOException("Could not read all bytes (stream broken): pos < res.length!");
                        }
                        break block9;
                    }
                }
                throw new IllegalStateException("unknown mode: " + this.mode);
            }
        }
        return res;
    }
}

