/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.io;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nightlabs.io.AbstractIOFilter;
import org.nightlabs.io.IOFilterWithProgress;

public abstract class AbstractIOFilterWithProgress
extends AbstractIOFilter
implements IOFilterWithProgress {
    public static final String PROGRESS_CHANGED = "progress changed";
    public static final String SUBTASK_FINISHED = "SubTask finished";
    protected PropertyChangeSupport pcs = null;
    protected int currentWork = 0;
    protected int totalWork = 100;
    protected boolean hasSubTasks = false;
    protected List subTasks = new ArrayList();
    protected Map subTask2Work = new HashMap();
    protected int totalSubTaskWork = 0;

    public AbstractIOFilterWithProgress() {
        this.pcs = new PropertyChangeSupport(this);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    protected void setCurrentWork(int work) {
        int oldWork = this.currentWork;
        this.currentWork = work;
        this.pcs.firePropertyChange(PROGRESS_CHANGED, oldWork, this.currentWork);
    }

    @Override
    public int getCurrentWork() {
        return this.currentWork;
    }

    @Override
    public int getTotalWork() {
        return this.totalWork;
    }

    @Override
    public boolean hasSubTasks() {
        return this.hasSubTasks;
    }

    public void setHasSubTasks(boolean b) {
        this.hasSubTasks = b;
    }

    @Override
    public List getSubTasks() {
        return this.subTasks;
    }

    @Override
    public Map getSubTask2Work() {
        return this.subTask2Work;
    }

    public void addSubTask(String name, int work) {
        if (!this.hasSubTasks) {
            this.hasSubTasks = true;
        }
        this.totalSubTaskWork += work;
        if (this.totalSubTaskWork > this.totalWork) {
            throw new IllegalArgumentException("Param work is to big, the addition of all subTasks is > then TotalWork!");
        }
        this.getSubTasks().add(name);
        this.getSubTask2Work().put(name, new Integer(work));
    }

    public void processSubTask(String name) {
        int oldWork = this.currentWork;
        Integer subTaskWork = (Integer)this.getSubTask2Work().get(name);
        if (subTaskWork != null) {
            int taskWork;
            this.currentWork = taskWork = subTaskWork.intValue();
            this.pcs.firePropertyChange(PROGRESS_CHANGED, oldWork, this.currentWork);
            this.pcs.firePropertyChange(SUBTASK_FINISHED, null, name);
        }
    }

    protected void flushSubTasks() {
        this.totalSubTaskWork = 0;
        this.hasSubTasks = false;
        this.subTask2Work = new HashMap();
        this.subTasks = new ArrayList();
    }
}

