/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.i18n.unit.resolution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nightlabs.i18n.unit.resolution.DPIResolutionUnit;
import org.nightlabs.i18n.unit.resolution.IResolutionUnit;

public class ResolutionUnitRegistry {
    protected static ResolutionUnitRegistry resolutionUnitRegistry = null;
    private Map<String, IResolutionUnit> resolutionUnitID2resolutionUnit = new HashMap<String, IResolutionUnit>();

    public static ResolutionUnitRegistry sharedInstance() {
        if (resolutionUnitRegistry == null) {
            resolutionUnitRegistry = new ResolutionUnitRegistry();
        }
        return resolutionUnitRegistry;
    }

    protected ResolutionUnitRegistry() {
        this.init();
    }

    protected void init() {
        this.addResolutionUnit(new DPIResolutionUnit());
    }

    public void addResolutionUnit(IResolutionUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("param unit must not be null!");
        }
        this.resolutionUnitID2resolutionUnit.put(unit.getResolutionID(), unit);
    }

    public void removeResolutionUnit(IResolutionUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("param unit must not be null!");
        }
        this.resolutionUnitID2resolutionUnit.remove(unit.getResolutionID());
    }

    public Collection<IResolutionUnit> getResolutionUnits() {
        return Collections.unmodifiableCollection(this.resolutionUnitID2resolutionUnit.values());
    }

    public IResolutionUnit getResolutionUnit(String resolutionID) {
        return this.resolutionUnitID2resolutionUnit.get(resolutionID);
    }

    public Collection<String> getResolutionIDs() {
        return Collections.unmodifiableCollection(this.resolutionUnitID2resolutionUnit.keySet());
    }
}

