/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.i18n.unit;

import java.util.Locale;
import org.nightlabs.i18n.unit.IUnit;
import org.nightlabs.i18n.unit.Unit;
import org.nightlabs.i18n.unit.resolution.Resolution;

public abstract class ResolutionUnit
extends Unit {
    protected Resolution resolution = null;

    public ResolutionUnit(Resolution resolution) {
        this.getName().setText(Locale.ENGLISH.getLanguage(), this.initName());
        this.unitID = this.initUnitID();
        this.symbol = this.initUnitSymbol();
        this.setResolution(resolution);
    }

    protected abstract String initName();

    protected abstract String initUnitID();

    protected abstract String initUnitSymbol();

    public void setResolution(Resolution resolution) {
        double factor;
        double resolutionY;
        IUnit unit = resolution.getResolutionUnit().getUnit();
        double resolutionX = resolution.getResolutionX();
        if (resolutionX != (resolutionY = resolution.getResolutionY())) {
            throw new IllegalArgumentException("The Resolution must have identical resolutions for X and Y!");
        }
        this.resolution = resolution;
        double unitFactor = unit.getFactor();
        this.factor = factor = resolutionX * unitFactor;
    }

    public Resolution getResolution() {
        return this.resolution;
    }
}

