/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.eclipse.ui.pdfviewer;

import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.nightlabs.eclipse.ui.pdfviewer.PdfDocument;

public abstract class AbstractPdfDocument
implements PdfDocument {
    private static final Logger logger = Logger.getLogger(AbstractPdfDocument.class);

    @Override
    public int getMostVisiblePage(Rectangle2D viewBounds) {
        Collection<Integer> visiblePages = this.getVisiblePages(viewBounds);
        if (logger.isDebugEnabled()) {
            for (int pageNumber : visiblePages) {
                logger.debug((Object)pageNumber);
            }
        }
        if (visiblePages.isEmpty()) {
            return -1;
        }
        int mostVisiblePage = -1;
        int visiblePageAreaMax = 0;
        for (int pageNumber : visiblePages) {
            int visiblePageArea;
            if (visiblePages.size() == 1) {
                return pageNumber;
            }
            Rectangle2D pageBounds = this.getPageBounds(pageNumber);
            if (viewBounds.contains(pageBounds)) {
                visiblePageArea = (int)(pageBounds.getWidth() * pageBounds.getHeight());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Page number: " + pageNumber + "; visible page area: " + visiblePageArea));
                }
            } else if (viewBounds.intersects(pageBounds)) {
                double x = Math.max(pageBounds.getX(), viewBounds.getX());
                double y = Math.max(pageBounds.getY(), viewBounds.getY());
                double width = Math.min(pageBounds.getMaxX() - x, viewBounds.getMaxX() - x);
                double height = Math.min(pageBounds.getMaxY() - y, viewBounds.getMaxY() - y);
                visiblePageArea = (int)(width * height);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Page number: " + pageNumber + "; visible page area: " + visiblePageArea));
                }
            } else {
                throw new IllegalStateException("Inconsistent implementation of PdfDocument! getVisiblePages(...) returned page " + pageNumber + " but this page is neither contained in the bounds, nor does it intersect them!");
            }
            if (visiblePageArea < visiblePageAreaMax || (visiblePageArea != visiblePageAreaMax || pageNumber >= mostVisiblePage) && visiblePageArea <= visiblePageAreaMax) continue;
            mostVisiblePage = pageNumber;
            visiblePageAreaMax = visiblePageArea;
        }
        return mostVisiblePage;
    }
}

