/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.pdf;

import ca.infodata.ofys.ui.library.LibPlugin;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PdfPlugin
extends AbstractUIPlugin {
    private static final Logger logger = Logger.getLogger(PdfPlugin.class);
    public static final String PLUGIN_ID = "ca.infodata.ofys.ui.pdf";
    private static PdfPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.deleteAllOldPdfFiles();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static PdfPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ca.infodata.ofys.data.client.dataaccess", (String)path);
    }

    public static String getOfysLocation() {
        return Platform.getInstallLocation().getURL().getPath();
    }

    private void deleteAllOldPdfFiles() {
        String path = String.valueOf(LibPlugin.OFYS_HOME) + "Temp/pdf/";
        this.deletePdfFiles(new File(path));
    }

    public static String getLocation() {
        String location = "";
        try {
            Bundle bundle = PdfPlugin.getDefault().getBundle();
            URL locationUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("/"), null);
            URL fileUrl = FileLocator.toFileURL((URL)locationUrl);
            location = fileUrl.getFile();
        }
        catch (IOException e) {
            logger.log(Priority.ERROR, (Object)"Exception on getLocation()", (Throwable)e);
        }
        return location;
    }

    private void deletePdfFiles(File f) {
        if (f.exists() && f.isDirectory()) {
            File[] pdfFile;
            File[] fileArray = pdfFile = f.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".pdf");
                }
            });
            int n = pdfFile.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                element.delete();
                ++n2;
            }
        }
    }
}

