/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.log;

import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.log.FrameworkLogRecord;
import ca.infodata.ofys.ui.library.log.LastOperationLogList;
import ca.infodata.ofys.ui.library.log.LogContextProvider;
import ca.infodata.ofys.ui.library.log.MedoStatsLogFormatter;
import ca.infodata.ofys.ui.library.log.MedoStatsLogHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class Log {
    public static final Logger logger = Logger.getLogger(Log.class.getName());
    private static final String LOG_FILE_NAME = "ofys%u.%g.log";
    private static boolean configured = false;
    private static File LOG_FILE_DIR;
    private static MedoStatsLogHandler medoStatsLogHandler;
    private static List<LogContextProvider> tempLogContextProviders;
    private static LastOperationLogList last50OperationLogList;
    private static final ILogListener plateformLogListener;
    private static long timeLoggerStart;

    static {
        tempLogContextProviders = new ArrayList<LogContextProvider>();
        last50OperationLogList = new LastOperationLogList();
        plateformLogListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                if (status.getMessage() == null) {
                    logger.log(FrameworkLogRecord.getLog(status));
                } else if (!(status.getMessage().contains("NLS unused message") || status.getMessage().contains("org.eclipse.tools.layout.spy") || status.getMessage().contains("Warnings while parsing the commands from the 'org.eclipse.ui.commands' and 'org.eclipse.ui.actionDefinitions' extension points"))) {
                    logger.log(FrameworkLogRecord.getLog(status));
                } else {
                    FrameworkLogRecord log = FrameworkLogRecord.getLog(status);
                    log.setLevel(Level.INFO);
                    logger.log(log);
                }
            }
        };
    }

    public static synchronized File getLogFileDir() throws IOException {
        File dir;
        if (LOG_FILE_DIR != null) {
            return LOG_FILE_DIR;
        }
        if (Platform.isRunning() && Log.ensureValidity(dir = new File(Platform.getInstanceLocation().getURL().getPath()))) {
            LOG_FILE_DIR = dir;
            return dir;
        }
        dir = new File(LibPlugin.OFYS_HOME);
        if (Log.ensureValidity(dir)) {
            LOG_FILE_DIR = dir;
            return dir;
        }
        String tmp = System.getProperty("java.io.tmpdir");
        if (tmp != null && Log.ensureValidity(dir = new File(tmp))) {
            LOG_FILE_DIR = dir;
            return dir;
        }
        throw new IOException("Failed to get a valid log directory");
    }

    private static boolean ensureValidity(File dir) {
        boolean exist = false;
        try {
            exist = dir.exists();
        }
        catch (Exception exception) {}
        if (!exist) {
            logger.info("Directory " + dir.getPath() + " does not exist. try to create...");
            try {
                exist = dir.mkdirs() && dir.exists();
            }
            catch (Exception exception) {}
            if (!exist) {
                logger.info("Failed to create " + dir.getPath() + ". abort");
                return false;
            }
        }
        boolean canWrite = false;
        if (exist) {
            try {
                canWrite = dir.canWrite();
            }
            catch (Exception exception) {}
            if (!canWrite) {
                logger.info("Directory " + dir.getPath() + " is not writable. try to set writable");
                try {
                    canWrite = dir.setWritable(true, true);
                }
                catch (Exception exception) {}
                if (!canWrite) {
                    logger.info("Failed to set directory " + dir.getPath() + " writable. abort");
                    return false;
                }
            }
        }
        return exist && canWrite;
    }

    public static File[] getNotInUseLogFiles() {
        File dir;
        try {
            dir = Log.getLogFileDir();
        }
        catch (IOException iOException) {
            return new File[0];
        }
        final String[] inUse = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".lck");
            }
        });
        File[] notInUse = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("ofys") && name.endsWith(".log") && Arrays.binarySearch(inUse, name, new Comparator<String>(){

                    @Override
                    public int compare(String source, String key) {
                        return source.substring(0, source.length() - 4).equals(key) ? 0 : source.compareTo(key);
                    }
                }) < 0;
            }
        });
        return notInUse;
    }

    public static synchronized void configure() throws SecurityException, IOException {
        LogManager.getLogManager().reset();
        Logger root = Logger.getLogger("");
        root.setLevel(Level.INFO);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        consoleHandler.setFormatter(new SimpleFormatter());
        root.addHandler(consoleHandler);
        boolean doNotLog = Boolean.getBoolean("doNotLog");
        if (!Platform.inDebugMode() && !doNotLog) {
            File logFileDir = Log.getLogFileDir();
            Log.cleanOldLogs(logFileDir);
            String pattern = String.valueOf(logFileDir.getAbsolutePath()) + File.separatorChar + LOG_FILE_NAME;
            FileHandler fileHandler = new FileHandler(pattern, 0, 999, false);
            fileHandler.setLevel(Level.INFO);
            fileHandler.setFormatter(new SimpleFormatter());
            root.addHandler(fileHandler);
            logger.info("Logging to " + pattern);
            String key = "ca.infodata.ofys.logs.url";
            String url = System.getProperty(key);
            logger.info(String.valueOf(key) + "=" + url);
            if (url == null) {
                url = "http://69.70.45.133:8080/";
            }
            medoStatsLogHandler = new MedoStatsLogHandler(url);
            medoStatsLogHandler.setLevel(Level.WARNING);
            medoStatsLogHandler.setFormatter(new MedoStatsLogFormatter());
            for (LogContextProvider p : tempLogContextProviders) {
                medoStatsLogHandler.registerLogContextProvider(p);
            }
            medoStatsLogHandler.registerLogContextProvider(last50OperationLogList);
            tempLogContextProviders.clear();
            root.addHandler(medoStatsLogHandler);
            logger.info("Logging to MedoStats at " + url);
        }
        configured = true;
    }

    private static void cleanOldLogs(File dir) {
        File[] list;
        final long oneWeekOld = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(14L);
        File[] fileArray = list = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.canWrite() && file.canRead() && (file.getName().endsWith(".log") || file.getName().endsWith(".mdmp")) && file.lastModified() <= oneWeekOld;
            }
        });
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                file.delete();
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    private Log() {
        throw new UnsupportedOperationException();
    }

    public static void severe(Throwable e) {
        logger.log(Level.SEVERE, "Erreur", e);
    }

    public static void severe(String message) {
        logger.severe(message);
    }

    public static void severe(String message, Exception e) {
        logger.log(Level.SEVERE, message, e);
    }

    public static void log(String s) {
        logger.info(s);
    }

    public static void log(Throwable e) {
        Log.severe(e);
    }

    @Deprecated
    public static void log(String title, Object o) {
        logger.severe(String.valueOf(title) + " : " + Log.computeLog(o, ""));
    }

    public static void log(Level level, String sourceClass, String sourceMethod) {
        logger.logp(level, sourceClass, sourceMethod, "");
    }

    public static void log(Level level, String sourceClass, String sourceMethod, String[] names, Object[] objects) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < objects.length) {
            b.append(String.valueOf(names[i].toString()) + " : " + Log.computeLog(objects[i], "") + ", ");
            ++i;
        }
        logger.logp(level, sourceClass, sourceMethod, b.toString());
    }

    public static String getPrintedStackTrace() {
        return Log.getPrintedStackTrace(null, 1, Integer.MAX_VALUE);
    }

    public static String getPrintedStackTrace(int offsetLevel, int deepLevel) {
        return Log.getPrintedStackTrace(null, 1 + offsetLevel, deepLevel);
    }

    private static String getPrintedStackTrace(String title, int offsetLevel, int deepLevel) {
        StackTraceElement[] elements = new Exception().getStackTrace();
        StringBuilder b = new StringBuilder(1000);
        if (title != null) {
            b.append(title);
            b.append("\n");
        }
        double deepLevel2 = (double)deepLevel + 2.0 + (double)offsetLevel;
        deepLevel = (int)Math.min(2.147483647E9, deepLevel2);
        int i = 1 + offsetLevel;
        while (i < elements.length && i < deepLevel) {
            b.append("\tat " + elements[i]);
            b.append("\n");
            ++i;
        }
        return b.toString();
    }

    public static void printStackTrace() {
        System.out.println(Log.getPrintedStackTrace(null, 1, Integer.MAX_VALUE));
    }

    public static void printStackTrace(String title, int deepLevel) {
        System.out.println(Log.getPrintedStackTrace(title, 1, deepLevel));
    }

    public static void printStackTrace(String title, int offsetLevel, int deepLevel) {
        System.out.println(Log.getPrintedStackTrace(title, 1 + offsetLevel, deepLevel));
    }

    public static void log(Logger customLogger, Level level, String title, String[] names, Object[] objects, boolean withTraces) {
        if (level == null) {
            level = Level.SEVERE;
        }
        if (customLogger == null) {
            customLogger = logger;
        }
        if (customLogger.isLoggable(level)) {
            StackTraceElement[] elements = new Exception().getStackTrace();
            if (withTraces) {
                StringBuilder b = new StringBuilder();
                b.append("--> " + elements[1].getClassName() + "." + elements[1].getMethodName() + "(" + title + ")(" + elements[2].getLineNumber() + ") ");
                int i = 0;
                while (i < objects.length) {
                    b.append(String.valueOf(names[i].toString()) + " : " + Log.computeLog(objects[i], "") + ", ");
                    ++i;
                }
                b.append("\n");
                b.append("    " + elements[2].getClassName() + "." + elements[2].getMethodName() + " (" + elements[2].getLineNumber() + ") ... " + elements[3].getClassName() + "." + elements[3].getMethodName() + " (" + elements[3].getLineNumber() + ")\n");
                customLogger.log(level, b.toString());
            } else {
                StringBuilder b = new StringBuilder();
                b.append(String.valueOf(title) + " --> ");
                int i = 0;
                while (i < objects.length) {
                    b.append(String.valueOf(names[i].toString()) + " : " + Log.computeLog(objects[i], "") + ", ");
                    ++i;
                }
                b.append("\n");
                customLogger.log(level, b.toString());
            }
        }
    }

    public static void log(Logger logger, Level level, String title, String[] names, Object[] objects) {
        Log.log(logger, level, title, names, objects, false);
    }

    public static void log(Logger logger, String title, String[] names, Object[] objects) {
        Log.log(logger, Level.FINE, title, names, objects, false);
    }

    private static String computeLog(Object o, String initial) {
        if (o instanceof List) {
            initial = String.valueOf(initial) + "[";
            int i = 0;
            while (i < ((List)o).size()) {
                initial = Log.computeLog(((List)o).get(i), initial);
                if (i < ((List)o).size() - 1) {
                    initial = String.valueOf(initial) + ",\n ";
                }
                ++i;
            }
            initial = String.valueOf(initial) + "]";
        } else {
            initial = o instanceof Calendar[] ? String.valueOf(initial) + (o == null ? "null" : Log.calendarArrayToString((Calendar[])o)) : (o instanceof Integer[] ? String.valueOf(initial) + (o == null ? "null" : Arrays.deepToString((Integer[])o)) : (o instanceof Calendar ? String.valueOf(initial) + (o == null ? "null" : Log.calendarToString((Calendar)o)) : (o instanceof Object[] ? String.valueOf(initial) + (o == null ? "null" : Arrays.deepToString((Object[])o)) : String.valueOf(initial) + (o == null ? "null" : o.toString()))));
        }
        return initial;
    }

    private static String calendarArrayToString(Calendar[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < a.length) {
            if (i == 0) {
                buf.append('[');
            } else {
                buf.append(", ");
            }
            if (a[i] == null) {
                buf.append("null");
            } else {
                buf.append(Log.calendarToString(a[i]));
            }
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    private static String calendarToString(Calendar a) {
        return String.valueOf(a.get(1)) + "-" + (a.get(2) + 1) + "-" + a.get(5);
    }

    public static void printTimeLogger(String text) {
        System.out.println(String.valueOf(text) + " : " + (System.currentTimeMillis() - timeLoggerStart));
    }

    public static void startTimeLogger() {
        timeLoggerStart = System.currentTimeMillis();
    }

    public static String getOpenEditorsLog() {
        StringBuilder b = new StringBuilder("OpenEditors\n");
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.getWorkbenchWindows().length > 0 && workbench.getWorkbenchWindows()[0].getPages().length > 0) {
            IEditorReference[] editorReferences;
            IWorkbenchPage page = workbench.getWorkbenchWindows()[0].getPages()[0];
            IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference er = iEditorReferenceArray[n2];
                String input = "unknown";
                try {
                    input = String.valueOf(er.getEditorInput());
                }
                catch (Exception exception) {}
                String isDirty = "unknown";
                try {
                    isDirty = String.valueOf(er.isDirty());
                }
                catch (Exception exception) {}
                try {
                    b.append(String.format("OpenEditor [id=%s, name=%s, dirty=%s, input=%s]", er.getId(), er.getName(), isDirty, input));
                    b.append('\n');
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        return b.toString();
    }

    public static String getOpenViewsLog() {
        StringBuilder b = new StringBuilder("OpenViews\n");
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.getWorkbenchWindows().length > 0 && workbench.getWorkbenchWindows()[0].getPages().length > 0) {
            IViewReference[] viewReferences;
            IWorkbenchPage page = workbench.getWorkbenchWindows()[0].getPages()[0];
            IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
            int n = viewReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference er = iViewReferenceArray[n2];
                if (page.isPartVisible(er.getPart(false))) {
                    String viewText = "";
                    try {
                        viewText = er.toString();
                    }
                    catch (Exception exception) {}
                    try {
                        b.append(String.format("OpenViews [id=%s, name=%s, viewText=%s]", er.getId(), er.getPartName(), viewText));
                        b.append('\n');
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        return b.toString();
    }

    public static void logOperation(String operation, Object ... params) {
        if (operation == null) {
            return;
        }
        if (params == null || params.length == 0) {
            logger.info(operation);
            last50OperationLogList.add(operation);
        } else if (params.length == 1) {
            String s = String.valueOf(operation) + " --> " + params[0];
            logger.info(s);
            last50OperationLogList.add(s);
        } else {
            StringBuilder b = new StringBuilder(100);
            b.append(operation);
            b.append(" --> ");
            int i = 0;
            while (i < params.length) {
                if (i != 0 && (i + 1) % 2 == 0) {
                    b.append("=").append(params[i]);
                    if (i != params.length - 1) {
                        b.append(", ");
                    }
                } else {
                    b.append(params[i]);
                }
                ++i;
            }
            logger.info(b.toString());
            last50OperationLogList.add(b.toString());
        }
    }

    public static void registerLogContextProvider(LogContextProvider provider) {
        if (medoStatsLogHandler != null) {
            medoStatsLogHandler.registerLogContextProvider(provider);
        } else {
            tempLogContextProviders.add(provider);
        }
    }

    public static void unregisterLogContextProvider(LogContextProvider provider) {
        if (medoStatsLogHandler != null) {
            medoStatsLogHandler.unregisterLogContextProvider(provider);
        } else {
            tempLogContextProviders.remove(provider);
        }
    }
}

