/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.h2cache;

import ca.infodata.ofys.ui.library.h2cache.AbstractEncryptedFileSystem;
import ca.infodata.util1.ClosureA;
import ca.infodata.util1.StringUtils;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamicStringTableEncryptedFileSystem
extends AbstractEncryptedFileSystem {
    private static final Logger logger = Logger.getLogger(DynamicStringTableEncryptedFileSystem.class.getName());
    private Map<String, String> h2FieldNameMapCallerFieldName = new HashMap<String, String>();
    private int sequence = 0;

    public DynamicStringTableEncryptedFileSystem(File file, String filePassword) throws ClassNotFoundException, SQLException {
        super(file, filePassword);
        this.initDatabase();
    }

    private void initDatabase() throws SQLException {
        Statement s = this.connection.createStatement();
        s.execute("CREATE TABLE IF NOT EXISTS BIGDATA (KEY INT PRIMARY KEY, SEQ INT);");
        s.close();
        s = this.connection.createStatement();
        s.execute("CREATE INDEX IDXSEQ ON BIGDATA(SEQ)");
        s.close();
        this.h2FieldNameMapCallerFieldName.put("KEY", "KEY");
        this.h2FieldNameMapCallerFieldName.put("SEQ", "SEQ");
    }

    public synchronized void put(Integer key, String field, String value) throws SQLException {
        if (key == null) {
            throw new NullPointerException("key cant be null");
        }
        if (field == null) {
            throw new NullPointerException("field cant be null");
        }
        String h2FieldName = this.computeH2FieldName(field);
        if (!this.fieldExist(h2FieldName)) {
            this.addField(field, h2FieldName);
        }
        try {
            if (this.exist(key)) {
                this.update(key, h2FieldName, value);
            } else {
                this.insert(key, h2FieldName, value);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to insert value for key " + key, e);
        }
    }

    private void insert(Integer key, String field, String value) {
        block6: {
            PreparedStatement s = null;
            try {
                try {
                    s = this.connection.prepareStatement("insert into bigdata (key, seq, " + field + ") values (?, ?, ?);");
                    s.setInt(1, key);
                    s.setInt(2, this.sequence++);
                    s.setString(3, value);
                    int n = s.executeUpdate();
                    if (n != 1) {
                        throw new SQLException("no row affected by insert");
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to insert value for key " + key, e);
                    DynamicStringTableEncryptedFileSystem.closeAll(null, s, null);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DynamicStringTableEncryptedFileSystem.closeAll(null, s, null);
                throw throwable;
            }
            DynamicStringTableEncryptedFileSystem.closeAll(null, s, null);
        }
    }

    private void update(Integer key, String field, String value) {
        block6: {
            PreparedStatement s = null;
            try {
                try {
                    s = this.connection.prepareStatement("update bigdata set " + field + " = ? where key = ?;");
                    s.setString(1, value);
                    s.setInt(2, key);
                    int n = s.executeUpdate();
                    if (n != 1) {
                        throw new SQLException("no row or more than 1 row affected by update");
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to update value for key " + key, e);
                    DynamicStringTableEncryptedFileSystem.closeAll(null, s, null);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DynamicStringTableEncryptedFileSystem.closeAll(null, s, null);
                throw throwable;
            }
            DynamicStringTableEncryptedFileSystem.closeAll(null, s, null);
        }
    }

    public boolean exist(Integer key) {
        boolean exist;
        block6: {
            if (key == null) {
                throw new NullPointerException("key cant be null");
            }
            PreparedStatement s = null;
            ResultSet rs = null;
            exist = false;
            try {
                try {
                    s = this.connection.prepareStatement("select key from bigdata where key = ?;");
                    s.setInt(1, key);
                    rs = s.executeQuery();
                    exist = rs.next();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to check exist value for key " + key, e);
                    DynamicStringTableEncryptedFileSystem.closeAll(rs, s, null);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DynamicStringTableEncryptedFileSystem.closeAll(rs, s, null);
                throw throwable;
            }
            DynamicStringTableEncryptedFileSystem.closeAll(rs, s, null);
        }
        return exist;
    }

    public synchronized List<String> getCallerFields() {
        ArrayList<String> list = new ArrayList<String>(this.h2FieldNameMapCallerFieldName.size());
        for (String field : this.h2FieldNameMapCallerFieldName.values()) {
            if (field.equals("SEQ") || field.equals("KEY")) continue;
            list.add(field);
        }
        return list;
    }

    public synchronized void iterate(ClosureA<Map<String, String>> closure) {
        block11: {
            if (closure == null) {
                throw new NullPointerException("closure cant be null");
            }
            PreparedStatement s = null;
            ResultSet rs = null;
            try {
                try {
                    s = this.connection.prepareStatement("select * from bigdata order by seq;");
                    s.setFetchSize(100);
                    rs = s.executeQuery();
                    ResultSetMetaData metaData = rs.getMetaData();
                    int columnCount = metaData.getColumnCount();
                    HashMap<String, String> map = new HashMap<String, String>(32);
                    while (rs.next()) {
                        map.clear();
                        int i = 1;
                        while (i <= columnCount) {
                            String columnName = metaData.getColumnName(i);
                            if (!columnName.equalsIgnoreCase("SEQ") && !columnName.equalsIgnoreCase("KEY")) {
                                map.put(this.h2FieldNameMapCallerFieldName.get(columnName), rs.getString(i));
                            }
                            ++i;
                        }
                        try {
                            closure.execute(map);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Error in closure execution while iterating " + map, e);
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error while iterating", e);
                    DynamicStringTableEncryptedFileSystem.closeAll(rs, s, null);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DynamicStringTableEncryptedFileSystem.closeAll(rs, s, null);
                throw throwable;
            }
            DynamicStringTableEncryptedFileSystem.closeAll(rs, s, null);
        }
    }

    private boolean fieldExist(String h2FieldName) {
        return this.h2FieldNameMapCallerFieldName.containsKey(h2FieldName);
    }

    private String computeH2FieldName(String s) {
        String s2 = StringUtils.NormalizeToUppercase((String)s).trim().replaceAll("\\s", "");
        String s3 = StringUtils.toAlphanumeric((String)s2);
        return "_" + s3 + "_";
    }

    private void addField(String field, String h2FieldName) throws SQLException {
        this.h2FieldNameMapCallerFieldName.put(h2FieldName, field);
        Statement s = null;
        try {
            s = this.connection.createStatement();
            s.execute("ALTER TABLE BIGDATA ADD COLUMN " + h2FieldName + " VARCHAR;");
            s.close();
        }
        finally {
            DynamicStringTableEncryptedFileSystem.closeAll(null, s, null);
        }
    }
}

