/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library;

import ca.infodata.ofys.city.ICityIndex;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.ui.library.ProxyStartupManager;
import ca.infodata.ofys.ui.library.PrpCache;
import ca.infodata.ofys.ui.library.RemoteDesktopRegStateListener;
import ca.infodata.ofys.ui.library.RemoteDesktopRegStateMonitor;
import ca.infodata.ofys.ui.library.city.CityIndex;
import ca.infodata.ofys.ui.library.file.FileUtil;
import ca.infodata.ofys.ui.library.h2cache.BigDataEncryptedFileSystem;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.library.log.LogContextProvider;
import ca.infodata.ofys.ui.library.printer.IPrinterList;
import ca.infodata.ofys.ui.library.printer.PrinterListFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class LibPlugin
extends AbstractUIPlugin {
    private static final Logger logger = Logger.getLogger(LogContextProviderImplementation.class.getName());
    public static final String OFYS_HOME = Platform.getUserLocation().getURL().getPath();
    public static final File OFYS_HOME_FILE = new File(OFYS_HOME);
    public static final String OS = Platform.getOS().toLowerCase();
    public static final boolean ON_MAC = OS.indexOf("mac") > -1;
    public static final boolean ON_WIN = OS.indexOf("win") > -1;
    public static final boolean ON_LINUX = OS.indexOf("linux") > -1;
    public static final boolean ON_MAC_OR_LINUX = ON_MAC || ON_LINUX;
    private static long time1 = 0L;
    private static long time2 = 0L;
    private static LibPlugin plugin;
    private static String codeclient;
    private static String username;
    private static String version;
    private LogContextProvider logContextProvider;
    private RemoteDesktopRegStateMonitor rdpStateMonitor;
    private RemoteDesktopRegStateListener rdpStateListener;
    private IPrinterList printerList;
    private PrpCache prpCache;
    private CityIndex cityIndex;
    private PrinterListFactory printerListFactory;

    static {
        version = "inconnu";
    }

    public static void setCodeClient(String codeclient) {
        LibPlugin.codeclient = codeclient;
    }

    public static String getCodeClient() {
        return codeclient;
    }

    public static void setUserName(String username) {
        LibPlugin.username = username;
    }

    public static String getUserName() {
        return username;
    }

    public static String getVersion() {
        return version;
    }

    public static LibPlugin getDefault() {
        return plugin;
    }

    public static boolean showTime(String msg) {
        if (msg.equals("1")) {
            time1 = System.currentTimeMillis();
        } else {
            time2 = System.currentTimeMillis();
            System.out.println(String.valueOf(msg) + ": " + (time2 - time1));
            time1 = System.currentTimeMillis();
        }
        return true;
    }

    public LibPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        System.out.println("LibPlugin.start()");
        super.start(context);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("ca/infodata/ofys/ui/library/version.txt")));
            version = reader.readLine();
            System.out.println("version = " + version);
            reader.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to read version", e);
        }
        File ofysHome = new File(OFYS_HOME);
        if (!ofysHome.exists()) {
            ofysHome.mkdirs();
        }
        ProxyStartupManager.startUp();
        Log.configure();
        logger.info("Temp folder is " + FileUtil.TEMP_FOLDER);
        logger.info("Configuration folder is " + Platform.getConfigurationLocation().getURL());
        this.logContextProvider = new LogContextProviderImplementation();
        Log.registerLogContextProvider(this.logContextProvider);
        this.rdpStateMonitor = new RemoteDesktopRegStateMonitor(10L, TimeUnit.SECONDS);
        this.printerListFactory = new PrinterListFactory();
        this.printerListFactory.setUseJavaPrinterList(this.isUseJavaPrinterListFromSettings());
        this.printerList = this.printerListFactory.newPrinterList();
        this.printerList.loadPrinterListAsync();
        this.rdpStateListener = new RemoteDesktopRegStateListener(){

            @Override
            public void regStateModified(String clientName, boolean isRDPSession) {
                LibPlugin.this.getPrinterList().loadPrinterListAsync();
            }
        };
        this.rdpStateMonitor.addListener(this.rdpStateListener);
        this.prpCache = new PrpCache();
        PrpCache.cleanupOldFilesAsync();
        this.cityIndex = new CityIndex();
        this.cityIndex.initAsync();
        CityIndex.cleanupOldFilesAsync();
        Application.get().setCityIndex((ICityIndex)this.cityIndex);
    }

    public BigDataEncryptedFileSystem getEncryptedFS() {
        return this.prpCache;
    }

    public IPrinterList getPrinterList() {
        return this.printerList;
    }

    public RemoteDesktopRegStateMonitor getRdpStateMonitor() {
        return this.rdpStateMonitor;
    }

    public CityIndex getCityIndex() {
        return this.cityIndex;
    }

    public void stop(BundleContext context) throws Exception {
        Log.unregisterLogContextProvider(this.logContextProvider);
        this.rdpStateMonitor.dispose();
        this.prpCache.closeAndDelete();
        this.cityIndex.dispose();
        super.stop(context);
    }

    public void setUseJavaPrinterList(boolean b) {
        logger.info("Setting new useJavaPrinterList value " + b + " to settings " + OFYS_HOME + ".global.xml");
        this.printerListFactory.setUseJavaPrinterList(b);
        this.printerList = this.printerListFactory.newPrinterList();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LibPlugin.this.printerList.loadPrinterListAsync();
            }
        });
        try {
            IDialogSettings settings = this.getDialogSettings();
            settings.put("useJavaPrinterList", b);
            settings.save(String.valueOf(OFYS_HOME) + ".global.xml");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error saving useJavaPrinterList config value to LibPlugin settings.", e);
        }
    }

    private boolean isUseJavaPrinterListFromSettings() {
        logger.info("Loading useJavaPrinterList settings from " + OFYS_HOME + ".global.xml");
        try {
            IDialogSettings settings = this.getDialogSettings();
            settings.load(String.valueOf(OFYS_HOME) + ".global.xml");
            boolean value = settings.getBoolean("useJavaPrinterList");
            logger.info("Loaded useJavaPrinterList settings from " + OFYS_HOME + ".global.xml VALUE=" + value);
            return value;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error reading useJavaPrinterList config value from LibPlugin settings. returning false", e);
            return false;
        }
    }

    public boolean isUseJavaPrinterList() {
        return this.printerListFactory.isUseJavaPrinterList();
    }

    private final class LogContextProviderImplementation
    implements LogContextProvider,
    Runnable {
        private String context;

        private LogContextProviderImplementation() {
        }

        @Override
        public String getContextElement() {
            return this.context;
        }

        @Override
        public void run() {
            this.context = "\n\n" + Log.getOpenEditorsLog() + "\n\n" + Log.getOpenViewsLog();
        }
    }
}

