/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro.handlers;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.LoginAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.intro.login.LauncherTool;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.IPair;
import ca.infodata.util1.Pair;
import ca.infodata.util1.encryption.DesEncrypter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SessionDialog {
    private static final Logger logger = Logger.getLogger(SessionDialog.class.getName());
    private static final String SE_DECONNECTER = Messages.getString((String)"SE_DECONNECTER", (String[])new String[0]);
    private static final String SESSION_OF = Messages.getString((String)"SESSION_OF", (String[])new String[0]);
    private static final String IS_LOCKED = Messages.getString((String)"IS_LOCKED", (String[])new String[0]);
    private static final String DEVERROUILLER_LA_SESSION = Messages.getString((String)"DEVERROUILLER_LA_SESSION", (String[])new String[0]);
    private static final String VERSION_OBSOLETE = Messages.getString((String)"VERSION_OBSOLETE", (String[])new String[0]);
    private static final String VERSION_OBSOLETE_CONTINUER_LE_TRAVAIL = Messages.getString((String)"VERSION_OBSOLETE_CONTINUER_LE_TRAVAIL", (String[])new String[0]);
    private static final String VERSION_OBSOLETE_REDEMARRER = Messages.getString((String)"VERSION_OBSOLETE_REDEMARRER", (String[])new String[0]);
    private static final String ENTRER_MOT_PASSE = Messages.getString((String)"ENTRER_MOT_PASSE", (String[])new String[0]);
    private static final String NO_ACTIVE_SESSION_YOUR_WERE_DISCONNECTED = Messages.getString((String)"NO_ACTIVE_SESSION_YOUR_WERE_DISCONNECTED", (String[])new String[0]);
    private static final String RETOURNER_A_LACCUEIL = Messages.getString((String)"RETOURNER_A_LACCUEIL", (String[])new String[0]);
    private static final String PRECEDENT = Messages.getString((String)"PRECEDENT", (String[])new String[0]);
    private Composite firstScreen;
    private Composite unlockScreen;
    private XSession activeSession;
    private XSession oldSession;
    private Shell window;
    private Color backgroundColor;
    private Composite currentScreen;
    private Composite badVersionScreen;
    private LauncherTool launcherTool = new LauncherTool();

    public Shell openDialog() {
        Shell shell = UI.getWorkbenchShell();
        if (shell == null || shell.isDisposed()) {
            logger.info("UI.getWorkbenchShell() is null or disposed, do not open SessionDialog");
            return null;
        }
        return this.openDialog(shell);
    }

    public Shell openDialog(Shell shell) {
        if (shell == null) {
            throw new NullPointerException("shell");
        }
        Log.logOperation((String)"SessionDialog.openDialog", (Object[])new Object[0]);
        this.window = new Shell(shell, 65536);
        this.window.setSize(shell.getSize());
        this.window.setLocation(shell.getLocation());
        this.window.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    e.doit = false;
                }
                if (e.detail == 4) {
                    e.doit = true;
                }
            }
        });
        final Display display = this.window.getDisplay();
        final Listener keyDownListener = new Listener(){

            public void handleEvent(Event e) {
                if (!SessionDialog.this.window.isDisposed() && display.getActiveShell() == SessionDialog.this.window && UI.ESC((Event)e)) {
                    e.doit = false;
                }
            }
        };
        display.addFilter(1, keyDownListener);
        this.window.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                display.removeFilter(1, keyDownListener);
            }
        });
        this.backgroundColor = ResourceGetter.getColorForWidget((int)128, (int)128, (int)128, (Widget)this.window);
        this.window.setBackground(this.backgroundColor);
        this.firstScreen = this.createFirstScreen((Composite)this.window);
        this.unlockScreen = this.createUnlockScreen((Composite)this.window);
        this.badVersionScreen = this.createBadVersionScreen((Composite)this.window);
        StackLayout layout = new StackLayout();
        layout.topControl = this.firstScreen;
        this.window.setLayout((Layout)layout);
        this.window.open();
        this.refresh();
        return this.window;
    }

    public void refresh() {
        Log.logOperation((String)"SessionDialog.refresh", (Object[])new Object[0]);
        if (!this.launcherTool.isInstalledVersionValid()) {
            if (this.currentScreen != this.badVersionScreen) {
                this.showScreen(this.badVersionScreen);
            } else {
                this.refreshScreen(this.currentScreen);
            }
        } else if (this.activeSession == null) {
            if (this.currentScreen == this.unlockScreen) {
                this.showScreen(this.firstScreen);
            } else {
                this.refreshScreen(this.currentScreen);
            }
        } else {
            this.refreshScreen(this.currentScreen);
        }
    }

    private Composite createFirstScreen(Composite parent) {
        Button button1;
        Button button2;
        Composite main = new Composite(parent, 0);
        main.setBackground(this.backgroundColor);
        Label lblMessage = new Label(main, 0x1000040);
        lblMessage.setBackground(this.backgroundColor);
        if (this.activeSession == null) {
            lblMessage.setText(NO_ACTIVE_SESSION_YOUR_WERE_DISCONNECTED);
            button2 = new Button(main, 0x1000008);
            button2.setText(RETOURNER_A_LACCUEIL);
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Log.logOperation((String)"SessionDialog.goToHome", (Object[])new Object[0]);
                    try {
                        UI.genericExecuteCommand((AbstractUIPlugin)IntroPlugin.getDefault(), (String)"ca.infodata.ofys.ui.intro.commands.homeCommand", (IPair[])new IPair[]{Pair.newPair((Object)"force", (Object)"true")});
                    }
                    catch (Exception exception) {}
                    try {
                        Application.get().getGlobalInstances().setSession(null);
                    }
                    catch (Exception exception) {
                        logger.log(Level.WARNING, "Failed to set session to null", e);
                    }
                    SessionDialog.this.window.close();
                }
            });
            button1 = new Button(main, 8);
            button1.setVisible(false);
        } else {
            lblMessage.setText(String.valueOf(SESSION_OF) + this.getActiveSession().getUser().getPersonNameOrTextOrEmpty() + IS_LOCKED);
            button1 = new Button(main, 0x1000008);
            button1.setText(DEVERROUILLER_LA_SESSION);
            button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SessionDialog.this.showScreen(SessionDialog.this.unlockScreen);
                }
            });
            button2 = new Button(main, 0x1000008);
            button2.setText(SE_DECONNECTER);
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Log.logOperation((String)"SessionDialog.logout", (Object[])new Object[0]);
                    SessionDialog.this.window.close();
                    try {
                        UI.genericExecuteCommand((AbstractUIPlugin)IntroPlugin.getDefault(), (String)"ca.infodata.ofys.ui.intro.commands.logoutCommand", (IPair[])new IPair[]{Pair.newPair((Object)"force", (Object)"true")});
                    }
                    catch (Exception exception) {}
                }
            });
        }
        Font font = ResourceGetter.getFontNormal((int)10);
        ResourceGetter.linkResourceWithWidgetLife((Object)font, (Widget)main);
        lblMessage.setFont(font);
        button1.setFont(font);
        button2.setFont(font);
        FormLayout layout = new FormLayout();
        layout.spacing = 10;
        main.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(40);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblMessage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)lblMessage, 30);
        Point button1Size = button1.computeSize(-1, -1);
        data.height = (int)((double)button1Size.y * 1.5);
        data.left = new FormAttachment(35);
        data.right = new FormAttachment(65);
        button1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)button1);
        data.height = (int)((double)button1Size.y * 1.5);
        data.left = new FormAttachment(35);
        data.right = new FormAttachment(65);
        button2.setLayoutData((Object)data);
        main.setTabList(new Control[]{button1, button2});
        return main;
    }

    private Composite createUnlockScreen(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setBackground(this.backgroundColor);
        final Label lblMessage = new Label(main, 0x1000000);
        lblMessage.setText(ENTRER_MOT_PASSE);
        lblMessage.setBackground(this.backgroundColor);
        final Text txtPassword = new Text(main, 20973568);
        final Button button1 = new Button(main, 0x1000008);
        button1.setText(DEVERROUILLER_LA_SESSION);
        button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionDialog.this.unlock(lblMessage, txtPassword, button1);
            }
        });
        txtPassword.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (UI.CR((KeyEvent)e)) {
                    SessionDialog.this.unlock(lblMessage, txtPassword, button1);
                }
            }
        });
        Button button2 = new Button(main, 0x1000008);
        button2.setText(PRECEDENT);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionDialog.this.showScreen(SessionDialog.this.firstScreen);
            }
        });
        Font font = ResourceGetter.getFontNormal((int)10);
        ResourceGetter.linkResourceWithWidgetLife((Object)font, (Widget)main);
        lblMessage.setFont(font);
        button1.setFont(font);
        button2.setFont(font);
        txtPassword.setFont(font);
        FormLayout layout = new FormLayout();
        layout.spacing = 10;
        main.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(40);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblMessage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)lblMessage, 30);
        data.left = new FormAttachment(35);
        data.right = new FormAttachment(65);
        txtPassword.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)txtPassword, 30);
        Point button1Size = button1.computeSize(-1, -1);
        data.height = (int)((double)button1Size.y * 1.5);
        data.left = new FormAttachment(35);
        data.right = new FormAttachment(65);
        button1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)button1);
        data.height = (int)((double)button1Size.y * 1.5);
        data.left = new FormAttachment(35);
        data.right = new FormAttachment(65);
        button2.setLayoutData((Object)data);
        main.setTabList(new Control[]{txtPassword, button1, button2});
        return main;
    }

    private Composite createBadVersionScreen(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setBackground(ResourceGetter.getRedWarningColor());
        Label lblMessage = new Label(main, 0x1000000);
        lblMessage.setText(VERSION_OBSOLETE);
        lblMessage.setBackground(ResourceGetter.getRedWarningColor());
        Button button1 = new Button(main, 0x1000008);
        button1.setText(VERSION_OBSOLETE_CONTINUER_LE_TRAVAIL);
        button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionDialog.this.continueWork();
            }
        });
        Button button2 = new Button(main, 0x1000008);
        button2.setText(VERSION_OBSOLETE_REDEMARRER);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionDialog.this.restartOfys();
            }
        });
        Font font = ResourceGetter.getFontNormal((int)5);
        ResourceGetter.linkResourceWithWidgetLife((Object)font, (Widget)main);
        lblMessage.setFont(font);
        button1.setFont(font);
        button2.setFont(font);
        FormLayout layout = new FormLayout();
        layout.spacing = 10;
        main.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(40);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblMessage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)lblMessage, 30);
        Point button1Size = button1.computeSize(-1, -1);
        data.height = (int)((double)button1Size.y * 1.5);
        data.left = new FormAttachment(35);
        data.right = new FormAttachment(65);
        button1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)button1);
        data.height = (int)((double)button1Size.y * 1.5);
        data.left = new FormAttachment(35);
        data.right = new FormAttachment(65);
        button2.setLayoutData((Object)data);
        main.setTabList(new Control[]{button1, button2});
        return main;
    }

    protected void restartOfys() {
        logger.info("SessionDialog.restartOfys()");
        try {
            this.launcherTool.doRestart();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error doing launcherTool.doRestart()", e);
        }
    }

    protected void continueWork() {
        System.out.println("SessionDialog.continueWork()");
        this.showScreen(this.unlockScreen);
    }

    private void unlock(final Label lblMessage, final Text txtPassword, final Button btnUnlock) {
        block7: {
            Log.logOperation((String)"SessionDialog.unlock", (Object[])new Object[0]);
            XSession session = this.getActiveSession();
            if (session == null) {
                this.firstScreen.dispose();
                this.firstScreen = this.createFirstScreen((Composite)this.window);
                this.showScreen(this.firstScreen);
            } else {
                String text = txtPassword.getText();
                String encryptedPassword = session.getUser().getEncryptedPassword();
                if (DesEncrypter.encryptMeOr((String)text, (String)"failed").equals(encryptedPassword)) {
                    try {
                        IStatus status = LoginAccessorClient.getInstance().unlockSession(session);
                        if (status.isOkToProceed()) {
                            this.close();
                            break block7;
                        }
                        MessageUtil.show((Shell)this.window, (IStatus)status);
                    }
                    catch (CannotConnectToServerException cannotConnectToServerException) {
                        MessageUtil.cannotConnectToServerExceptionMsg((Shell)this.window);
                    }
                } else {
                    final String text1 = lblMessage.getText();
                    lblMessage.setText("Mot de passe invalide");
                    txtPassword.setEnabled(false);
                    txtPassword.setText("");
                    btnUnlock.setEnabled(false);
                    lblMessage.getDisplay().timerExec(1000, new Runnable(){

                        @Override
                        public void run() {
                            if (!lblMessage.isDisposed()) {
                                lblMessage.setText(text1);
                            }
                            if (!txtPassword.isDisposed()) {
                                txtPassword.setEnabled(true);
                            }
                            if (!btnUnlock.isDisposed()) {
                                btnUnlock.setEnabled(true);
                            }
                        }
                    });
                }
            }
        }
    }

    private void close() {
        this.window.close();
    }

    private void refreshScreen(Composite screen) {
    }

    private void showScreen(Composite screen) {
        this.currentScreen = screen;
        ((StackLayout)this.window.getLayout()).topControl = screen;
        this.window.layout();
        screen.setFocus();
    }

    public XSession getActiveSession() {
        return this.activeSession;
    }

    public void setActiveSession(XSession activeSession) {
        this.activeSession = activeSession;
    }

    public XSession getOldSession() {
        return this.oldSession;
    }

    public void setOldSession(XSession oldSession) {
        this.oldSession = oldSession;
    }
}

