/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XModule;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.util1.StringUtils;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.ui.AbstractSourceProvider;

public class SessionSourceProvider
extends AbstractSourceProvider {
    private static final Logger logger = Logger.getLogger(SessionSourceProvider.class.getName());
    public static final String USER_ROLE = "ca.infodata.ofys.ui.userRole";
    public static final String USER_ROLE_IS_HEALTCARE = "ca.infodata.ofys.ui.userRole.healtcare";
    public static final String USER_ROLE_IS_ADMIN = "ca.infodata.ofys.ui.userRole.admin";
    public static final String USER_ROLE_IS_INFODATA = "ca.infodata.ofys.ui.userRole.infodata";
    public static final String USER_ROLE_IS_SECMED = "ca.infodata.ofys.ui.userRole.secmed";
    public static final String USER_ROLE_IS_SEC = "ca.infodata.ofys.ui.userRole.sec";
    public static final String SESSION_ROLE_IS_SECMED = "ca.infodata.ofys.ui.sessionRole.secmed";
    public static final String SESSION_ROLE_IS_ADMIN = "ca.infodata.ofys.ui.sessionRole.admin";
    public static final String SESSION_ROLE_IS_BILLING = "ca.infodata.ofys.ui.sessionRole.billing";
    public static final String LOGGED_IN = "ca.infodata.ofys.ui.loggedIn";
    public static final String SITES_LOADED = "ca.infodata.ofys.ui.sitesLoaded";
    public static final String HAS_MODULE_LABO = "ca.infodata.ofys.ui.hasModuleLabo";
    public static final String HAS_MODULE_SCAN = "ca.infodata.ofys.ui.hasModuleScan";
    public static final String HAS_MODULE_ENCOUNTER = "ca.infodata.ofys.ui.hasModuleEncounter";
    public static final String HAS_MODULE_APPOINTMENT = "ca.infodata.ofys.ui.hasModuleAppointment";
    public static final String HAS_MODULE_DSQ = "ca.infodata.ofys.ui.hasModuleDsq";
    public static final String HAS_MODULE_BILLING = "ca.infodata.ofys.ui.hasModuleBilling";
    public static final String HAS_MODULE_INDEX = "ca.infodata.ofys.ui.hasModuleIndex";
    public static final String DEBUG_MODE_ON = "ca.infodata.ofys.ui.debugModeOn";

    public void dispose() {
    }

    public Map<String, String> getCurrentState() {
        HashMap<String, String> currentState = new HashMap<String, String>(1);
        currentState.put(LOGGED_IN, SessionSourceProvider.isLoggedIn());
        currentState.put(SITES_LOADED, this.sitesLoaded());
        currentState.put(HAS_MODULE_APPOINTMENT, SessionSourceProvider.hasModule(XModule.APPOINTMENT));
        currentState.put(HAS_MODULE_BILLING, SessionSourceProvider.hasModule(XModule.BILLING));
        currentState.put(HAS_MODULE_DSQ, SessionSourceProvider.hasModule(XModule.DSQ));
        currentState.put(HAS_MODULE_ENCOUNTER, SessionSourceProvider.hasModule(XModule.ENCOUNTER));
        currentState.put(HAS_MODULE_INDEX, SessionSourceProvider.hasModule(XModule.INDEX));
        currentState.put(HAS_MODULE_LABO, SessionSourceProvider.hasModule(XModule.LABO));
        currentState.put(HAS_MODULE_SCAN, SessionSourceProvider.hasModule(XModule.SCAN));
        currentState.put(USER_ROLE, SessionSourceProvider.getUserRole());
        currentState.put(USER_ROLE_IS_ADMIN, SessionSourceProvider.getUserRoleAdmin());
        currentState.put(USER_ROLE_IS_INFODATA, SessionSourceProvider.getUserRoleInfodata());
        currentState.put(USER_ROLE_IS_SEC, SessionSourceProvider.getUserRoleSec());
        currentState.put(USER_ROLE_IS_SECMED, SessionSourceProvider.getUserRoleMedSec());
        currentState.put(USER_ROLE_IS_HEALTCARE, SessionSourceProvider.getUserRoleProf());
        currentState.put(SESSION_ROLE_IS_SECMED, SessionSourceProvider.getSessionRoleSecMed());
        currentState.put(SESSION_ROLE_IS_ADMIN, SessionSourceProvider.getSessionRoleAdmin());
        currentState.put(SESSION_ROLE_IS_BILLING, SessionSourceProvider.getSessionRoleBilling());
        currentState.put(DEBUG_MODE_ON, SessionSourceProvider.getDebugModeOn());
        return currentState;
    }

    private String sitesLoaded() {
        boolean b = false;
        try {
            Stream sites = Application.get().getSitePluginController().getSites();
            b = sites != null && sites.findAny() != null;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get sitesLoaded.=", e);
        }
        return b ? "t" : "f";
    }

    private static String hasModule(XModule m) {
        boolean b = false;
        try {
            XSession session = Application.get().getGlobalInstances().getSession();
            b = session != null;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get hasModule. default to false. module=" + m, e);
        }
        return b ? "t" : "f";
    }

    private static String isLoggedIn() {
        boolean b = false;
        try {
            XSession session = Application.get().getGlobalInstances().getSession();
            b = session != null;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get isLoggedIn. default to false.", e);
        }
        return b ? "t" : "f";
    }

    private static String getUserRoleAdmin() {
        if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().hasOneOfRoles(new XUserRole[]{XUserRole.ADMIN})) {
            return "t";
        }
        return "f";
    }

    private static String getUserRoleInfodata() {
        if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().hasOneOfRoles(new XUserRole[]{XUserRole.INFODATA})) {
            return "t";
        }
        return "f";
    }

    private static String getUserRoleProf() {
        if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().hasOneOfRoles(new XUserRole[]{XUserRole.HEALTHCARE_PROVIDER})) {
            return "t";
        }
        return "f";
    }

    private static String getUserRoleMedSec() {
        if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().hasOneOfRoles(new XUserRole[]{XUserRole.MEDICAL_SECRETARY})) {
            return "t";
        }
        return "f";
    }

    private static String getUserRoleSec() {
        if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().hasOneOfRoles(new XUserRole[]{XUserRole.SECRETARY})) {
            return "t";
        }
        return "f";
    }

    private static String getSessionRoleSecMed() {
        if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().hasOneOfRoles(new XUserRole[]{XUserRole.MEDICAL_SECRETARY})) {
            return "t";
        }
        return "f";
    }

    private static String getSessionRoleAdmin() {
        if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().hasOneOfRoles(new XUserRole[]{XUserRole.ADMIN})) {
            return "t";
        }
        return "f";
    }

    private static String getSessionRoleBilling() {
        if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().hasOneOfRoles(new XUserRole[]{XUserRole.BILLING})) {
            return "t";
        }
        return "f";
    }

    private static String getDebugModeOn() {
        if (Application.get().getGlobalInstances().inDebugMode()) {
            return "t";
        }
        return "f";
    }

    private static String getUserRole() {
        try {
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null) {
                EnumSet roles = session.getUser().getCrisisManagedRole();
                String stringRole = roles.toString();
                logger.log(Level.INFO, "User session roles: " + stringRole);
                if (StringUtils.isBlank((CharSequence)stringRole)) {
                    throw new RuntimeException("user roles not in switch : " + roles);
                }
                return stringRole;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get user role. default to null.", e);
        }
        return null;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{DEBUG_MODE_ON, LOGGED_IN, USER_ROLE, HAS_MODULE_APPOINTMENT, HAS_MODULE_BILLING, HAS_MODULE_DSQ, HAS_MODULE_ENCOUNTER, HAS_MODULE_INDEX, HAS_MODULE_LABO, HAS_MODULE_SCAN};
    }

    public void refresh() {
        this.fireSourceChanged(0, LOGGED_IN, SessionSourceProvider.isLoggedIn());
        this.fireSourceChanged(0, USER_ROLE, SessionSourceProvider.getUserRole());
        this.fireSourceChanged(0, USER_ROLE_IS_INFODATA, SessionSourceProvider.getUserRoleInfodata());
        this.fireSourceChanged(0, USER_ROLE_IS_ADMIN, SessionSourceProvider.getUserRoleAdmin());
        this.fireSourceChanged(0, USER_ROLE_IS_HEALTCARE, SessionSourceProvider.getUserRoleProf());
        this.fireSourceChanged(0, USER_ROLE_IS_SECMED, SessionSourceProvider.getUserRoleMedSec());
        this.fireSourceChanged(0, USER_ROLE_IS_SEC, SessionSourceProvider.getUserRoleSec());
        this.fireSourceChanged(0, SESSION_ROLE_IS_SECMED, SessionSourceProvider.getSessionRoleSecMed());
        this.fireSourceChanged(0, SESSION_ROLE_IS_ADMIN, SessionSourceProvider.getSessionRoleAdmin());
        this.fireSourceChanged(0, SESSION_ROLE_IS_BILLING, SessionSourceProvider.getSessionRoleBilling());
        this.fireSourceChanged(0, HAS_MODULE_APPOINTMENT, SessionSourceProvider.hasModule(XModule.APPOINTMENT));
        this.fireSourceChanged(0, HAS_MODULE_BILLING, SessionSourceProvider.hasModule(XModule.BILLING));
        this.fireSourceChanged(0, HAS_MODULE_DSQ, SessionSourceProvider.hasModule(XModule.DSQ));
        this.fireSourceChanged(0, HAS_MODULE_ENCOUNTER, SessionSourceProvider.hasModule(XModule.ENCOUNTER));
        this.fireSourceChanged(0, HAS_MODULE_INDEX, SessionSourceProvider.hasModule(XModule.INDEX));
        this.fireSourceChanged(0, HAS_MODULE_LABO, SessionSourceProvider.hasModule(XModule.LABO));
        this.fireSourceChanged(0, HAS_MODULE_SCAN, SessionSourceProvider.hasModule(XModule.SCAN));
        this.fireSourceChanged(0, DEBUG_MODE_ON, SessionSourceProvider.getDebugModeOn());
    }
}

