/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.ui.intro.IntroWindowAdvisor;
import ca.infodata.ofys.ui.intro.PerspectiveManager;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.file.FileUtil;
import ca.infodata.util1.date.DateUtil;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class IntroAdvisor
extends WorkbenchAdvisor {
    private static final Logger logger = Logger.getLogger(IntroAdvisor.class.getName());

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new IntroWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return PerspectiveManager.getInitialPerspective().id;
    }

    public void postStartup() {
        super.postStartup();
        Application.get().getGlobalInstances().setLocale(IntroAdvisor.getPlatformLocale());
        FileUtil.deleteTempFolder();
    }

    private static Locale getPlatformLocale() {
        String nl = Platform.getNL();
        Locale locale = DateUtil.parseLocale((String)nl);
        if (locale == null) {
            logger.log(Level.WARNING, String.valueOf(nl) + "is not a valid iso locale");
        }
        return locale;
    }

    public boolean preShutdown() {
        return true;
    }

    public void postShutdown() {
        Application.get().getGlobalInstances().logout();
        ResourceGetter.disposeAllResouces();
        FileUtil.deleteTempFolder();
    }

    public void postWindowClose() {
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
    }
}

